/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.twofactor.server.internal;

import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.TwoFactorManager;
import com.inet.authentication.twofactor.TwoFactorAuthenticationServerPlugin;
import com.inet.authentication.twofactor.api.TwoFactorProvider;
import com.inet.authentication.twofactor.api.TwoFactorSetting;
import com.inet.authentication.twofactor.server.internal.a;
import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.servlet.SessionStore;
import com.inet.http.utils.Browser;
import com.inet.http.utils.UserAgent;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class d
implements TwoFactorManager {
    private static final d h = new d();
    private static final ConfigValue<Boolean> i = new ConfigValue(com.inet.authentication.twofactor.structure.a.n);
    private static final ConfigValue<InetAddress[]> j = new ConfigValue<InetAddress[]>(com.inet.authentication.twofactor.structure.a.o){

        protected InetAddress[] c(@Nonnull String string) {
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            try {
                for (String string2 : string.split("[,; ]")) {
                    if (string2.isEmpty()) continue;
                    arrayList.add(InetAddress.getByName(string2));
                }
            }
            catch (Throwable throwable) {
                LoginProcessor.LOGGER.error(throwable);
            }
            return arrayList.toArray(new InetAddress[arrayList.size()]);
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.c(string);
        }
    };
    private Map<String, TwoFactorProvider> k;

    public static d b() {
        return h;
    }

    public boolean forceTwoFactor() {
        return (Boolean)i.get();
    }

    @Nonnull
    public List<TwoFactorProvider> a(@Nonnull GUID gUID) {
        this.b("");
        UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(gUID);
        ArrayList<TwoFactorProvider> arrayList = new ArrayList<TwoFactorProvider>();
        for (TwoFactorProvider twoFactorProvider : this.k.values()) {
            if (!twoFactorProvider.available(userAccount)) continue;
            arrayList.add(twoFactorProvider);
        }
        return arrayList;
    }

    public boolean a(@Nonnull GUID gUID, @Nonnull GUID gUID2, String string) {
        List<TwoFactorSetting> list = this.b(gUID);
        if (list == null) {
            return false;
        }
        for (TwoFactorSetting twoFactorSetting : list) {
            if (!gUID2.equals((Object)twoFactorSetting.id)) continue;
            return this.a(twoFactorSetting, string);
        }
        return false;
    }

    public boolean a(@Nonnull TwoFactorSetting twoFactorSetting, String string) {
        TwoFactorProvider twoFactorProvider = this.b(twoFactorSetting.provider);
        if (twoFactorProvider == null) {
            return false;
        }
        return twoFactorProvider.validateTwoFactorCode(string, twoFactorSetting.data);
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data are save")
    public boolean check(@Nonnull UserAccount user, @Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        String string;
        HttpSession httpSession;
        HttpSession httpSession2 = httpSession = request != null ? request.getSession() : SessionStore.getHttpSession();
        if (httpSession == null) {
            return false;
        }
        if (httpSession.getAttribute("Login.TwoFactor") != null) {
            return true;
        }
        List<TwoFactorSetting> list = this.a(user);
        if (!(list != null && list.size() != 0 || ((Boolean)i.get()).booleanValue() && user.getAccountType() != UserAccountType.Guest)) {
            return true;
        }
        if (request == null) {
            return false;
        }
        if (response == null || response.isCommitted()) {
            return false;
        }
        String string2 = request.getServletPath();
        if (string2.startsWith("/websocket")) {
            return false;
        }
        if (string2.startsWith("/weblib/")) {
            return false;
        }
        if (string2.startsWith("/login/weblib/")) {
            return false;
        }
        if (string2.startsWith("/login/twofactor")) {
            return false;
        }
        if (string2.startsWith("/login/forcetwofactor")) {
            return false;
        }
        if (string2.startsWith("/logout")) {
            return false;
        }
        String string3 = request.getParameter("method");
        if (string2.startsWith("/signup") && "POST".equals(request.getMethod()) && "signup_createaccount".equals(string3)) {
            return false;
        }
        if (string2.startsWith("/start") && "POST".equals(request.getMethod()) && !StringFunctions.isEmpty((String)string3)) {
            return false;
        }
        if (((Boolean)i.get()).booleanValue() && ((InetAddress[])j.get()).length > 0 && !StringFunctions.isEmpty((String)(string = request.getLocalAddr()))) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                for (InetAddress inetAddress2 : (InetAddress[])j.get()) {
                    if (!inetAddress2.equals(inetAddress)) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                LoginProcessor.LOGGER.error(throwable);
            }
        }
        if (list == null || list.size() == 0) {
            try {
                httpSession.setAttribute("AccontID.TwoFactor", (Object)user.getID());
                PluginDispatcherServlet.forward((String)"/login/forcetwofactor", (HttpServletRequest)request, (HttpServletResponse)response);
                response.getOutputStream().close();
            }
            catch (ServletException | IOException throwable) {
                throw (RuntimeException)ErrorCode.throwAny((Throwable)throwable);
            }
            return false;
        }
        long l = list.stream().map(twoFactorSetting -> this.b(twoFactorSetting.provider)).filter(twoFactorProvider -> twoFactorProvider != null).count();
        if (l > 0L) {
            try {
                if (new UserAgent((String)request.getHeader((String)"User-Agent")).browser.equals((Object)Browser.HdMobile)) {
                    response.setContentType("application/helpdesk-error-json");
                    HashMap hashMap = new HashMap();
                    hashMap.put("cmd", "error");
                    hashMap.put("json", new Json().toJson((Object)TwoFactorAuthenticationServerPlugin.MSG.getMsg("twofactor.hdmobile.error", new Object[0])));
                    new Json().toJson((Object)hashMap, (OutputStream)response.getOutputStream());
                } else {
                    httpSession.setAttribute("AccontID.TwoFactor", (Object)user.getID());
                    PluginDispatcherServlet.forward((String)"/login/twofactor", (HttpServletRequest)request, (HttpServletResponse)response);
                }
                response.getOutputStream().close();
            }
            catch (ServletException | IOException throwable) {
                ErrorCode.throwAny((Throwable)throwable);
            }
            return false;
        }
        return true;
    }

    @Nullable
    private List<TwoFactorSetting> b(@Nonnull GUID gUID) {
        UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(gUID);
        return this.a(userAccount);
    }

    @Nullable
    private List<TwoFactorSetting> a(@Nonnull UserAccount userAccount) {
        String string = (String)userAccount.getValue((UserField)a.f);
        if (StringFunctions.isEmpty((String)string)) {
            return null;
        }
        try {
            return (List)new Json().fromJson(string, (Type)new JsonParameterizedType(List.class, new Type[]{TwoFactorSetting.class}));
        }
        catch (JsonException jsonException) {
            LoginProcessor.LOGGER.error((Throwable)jsonException);
            return null;
        }
    }

    public boolean hasTwoFactorSettings(@Nonnull UserAccount user) {
        List<TwoFactorSetting> list = this.a(user);
        return list != null && list.size() > 0;
    }

    @Nullable
    public TwoFactorProvider b(String string) {
        Map<String, TwoFactorProvider> map = this.k;
        if (map == null) {
            map = new HashMap<String, TwoFactorProvider>();
            for (TwoFactorProvider twoFactorProvider : ServerPluginManager.getInstance().get(TwoFactorProvider.class)) {
                map.put(twoFactorProvider.getExtensionName(), twoFactorProvider);
            }
            this.k = map;
        }
        return map.get(string);
    }
}

