/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.token.server;

import com.inet.authentication.AccessForbiddenException;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.TokenAuthenticationProvider;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.token.TokenAuthenticationServerPlugin;
import com.inet.authentication.token.api.TokenPermission;
import com.inet.authentication.token.api.TokenPermissionGroup;
import com.inet.authentication.token.server.b;
import com.inet.authentication.token.server.bearer.TokenLoginData;
import com.inet.authentication.token.server.data.TokenResponseData;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a {
    public static final a c = new a();
    private final ConcurrentHashMap<String, a> d = new ConcurrentHashMap();
    private final List<b> e = new CopyOnWriteArrayList<b>();
    private List<@Nonnull TokenPermissionGroup> f;
    private Map<String, TokenPermission> g;

    private a() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    public List<LocalizedKey> a() {
        @Nonnull List list = DynamicExtensionManager.getInstance().get(AuthenticationProvider.class);
        list.removeIf(authenticationProvider -> !(authenticationProvider instanceof TokenAuthenticationProvider));
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        block0: for (AuthenticationDescription authenticationDescription : LoginManager.getAllAuthenticationDescriptions()) {
            String string = authenticationDescription.getName();
            for (AuthenticationProvider authenticationProvider2 : list) {
                if (!authenticationProvider2.name().equals(string)) continue;
                arrayList.add(new LocalizedKey(string, TokenAuthenticationServerPlugin.MSG.getMsg(string + ".token", new Object[0])));
                continue block0;
            }
        }
        return arrayList;
    }

    public TokenResponseData a(@Nonnull String string, @Nullable String string2) {
        Object object;
        switch (string) {
            case "bearer": {
                if (string2 == null) {
                    string2 = GUID.generateNew().toString();
                }
                object = string2 + String.valueOf(GUID.generateNew());
                break;
            }
            case "hmac": {
                object = "";
                string2 = null;
                break;
            }
            default: {
                throw new InternalError(string);
            }
        }
        return new TokenResponseData(string, string2, (String)object);
    }

    public List<@Nonnull TokenPermissionGroup> b() {
        List<@Nonnull T> list = this.f;
        if (list == null) {
            list = ServerPluginManager.getInstance().get(TokenPermissionGroup.class);
            if (ServerPluginManager.getInstance().isPluginLoaded("webapi.core")) {
                list.addAll(com.inet.authentication.token.server.webapi.a.h().i());
            }
            list = Collections.unmodifiableList(list);
            this.f = list;
        }
        return list;
    }

    @Nullable
    public TokenPermission a(String string) {
        Map<String, TokenPermission> map = this.g;
        if (map == null) {
            map = new HashMap<String, TokenPermission>();
            for (TokenPermissionGroup tokenPermissionGroup : this.b()) {
                for (TokenPermission tokenPermission : tokenPermissionGroup.getPermissions()) {
                    map.put(tokenPermission.getPermissionKey(), tokenPermission);
                }
            }
            this.g = map;
        }
        return map.get(string);
    }

    @Nullable
    public LoginProcessor a(@Nonnull TokenLoginData tokenLoginData, @Nonnull String string, @Nonnull String string2, @Nonnull GUID gUID, @Nonnull String string3) {
        for (String string4 : tokenLoginData.getPermissions()) {
            TokenPermission tokenPermission = this.a(string4);
            if (tokenPermission == null) continue;
            for (String string5 : tokenPermission.getAllowedPaths()) {
                if (!string.startsWith(string5)) continue;
                this.b(string3, string2);
                return UserManager.getInstance().getNonSessionLoginProcessor(gUID, string2, string3);
            }
        }
        if ("/api".equals(string) || "/api/".equals(string)) {
            this.b(string3, string2);
            return UserManager.getInstance().getNonSessionLoginProcessor(gUID);
        }
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null) {
            httpServletRequest.setAttribute("Login.Exception", (Object)new AccessForbiddenException());
        }
        return null;
    }

    public void b(String string, String string2) {
        this.d.put(string2, new a(string, System.currentTimeMillis()));
    }

    public boolean c() {
        if (this.d.isEmpty()) {
            return false;
        }
        Json json = new Json();
        Iterator<Map.Entry<String, a>> iterator = this.d.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry<String, a> entry = iterator.next();
            iterator.remove();
            String string = entry.getKey();
            a a2 = entry.getValue();
            UserManager userManager = UserManager.getInstance();
            UserAccount userAccount = userManager.findActiveUserAccount(a2.loginSource, string);
            if (userAccount == null) continue;
            for (LoginSettings loginSettings : userAccount.getLoginSettings()) {
                if (!a2.loginSource.equals(loginSettings.getLoginSource()) || !string.equalsIgnoreCase(loginSettings.getLoginID())) continue;
                String string2 = loginSettings.getAdditionalData();
                String string3 = loginSettings.getDisplayName();
                TokenLoginData tokenLoginData = (TokenLoginData)json.fromJson(string2, TokenLoginData.class);
                Objects.requireNonNull(tokenLoginData);
                tokenLoginData.setLastUsed(a2.h);
                string2 = json.toJson((Object)tokenLoginData);
                LoginSettings loginSettings2 = new LoginSettings(a2.loginSource, string, string2, string3);
                userManager.updateLoginSettings(userAccount.getID(), Arrays.asList(loginSettings2), Arrays.asList(loginSettings), false);
                continue block0;
            }
        }
        return true;
    }

    public void a(@Nonnull b b2) {
        this.e.add(Objects.requireNonNull(b2));
    }

    public void d() {
        for (b b2 : this.e) {
            b2.save();
        }
    }

    static {
        ShutdownManager.add(() -> c.c());
    }

    private static class a {
        private final String loginSource;
        private final long h;

        public a(String string, long l) {
            this.loginSource = string;
            this.h = l;
        }
    }
}

