/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.token.api;

import com.inet.annotations.InternalApi;
import com.inet.authentication.token.api.TokenPermissionGroup;
import com.inet.plugin.NamedExtension;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public interface TokenPermission
extends NamedExtension {
    @Nonnull
    public String getTitle();

    @Nonnull
    public String getDescription();

    @Nonnull
    public @Nonnull List<@Nonnull String> getAllowedPaths();

    @Nonnull
    public TokenPermissionGroup getGroup();

    @Nonnull
    default public String getPermissionKey() {
        if (!this.getGroup().getPermissions().parallelStream().anyMatch(tokenPermission -> tokenPermission.getExtensionName().equalsIgnoreCase(this.getExtensionName()))) {
            throw new IllegalArgumentException("The given Token Permission '" + this.getExtensionName() + "' does not belong to the permission group '" + this.getGroup().getExtensionName() + "'.");
        }
        return this.getGroup().getExtensionName() + "." + this.getExtensionName();
    }
}

