/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.token.usersandgroups;

import com.inet.authentication.base.LoginManager;
import com.inet.authentication.token.TokenAuthenticationServerPlugin;
import com.inet.authentication.token.server.bearer.TokenLoginData;
import com.inet.authentication.token.usersandgroups.data.TokenFieldValue;
import com.inet.authentication.token.usersandgroups.data.TokenFieldValueData;
import com.inet.classloader.translations.TranslationKey;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.PasswordHashing;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class a
extends UserFieldDefinition<List<TokenFieldValueData>> {
    public a() {
        super("user.token", "token", "fieldtype_token_authentication", 100);
    }

    public String getLabel() {
        return null;
    }

    public FieldValue getFieldValue(@Nullable UserAccount userAccount) {
        return new TokenFieldValue(this.a(userAccount));
    }

    private List<TokenFieldValueData> a(UserAccount userAccount) {
        ArrayList<TokenFieldValueData> arrayList = new ArrayList<TokenFieldValueData>();
        if (userAccount != null) {
            if (com.inet.authentication.token.server.a.c.c()) {
                userAccount = UserManager.getInstance().getUserAccount(userAccount.getID());
            }
            Json json = new Json();
            List list = userAccount.getLoginSettings();
            for (LoginSettings loginSettings : list) {
                String string;
                String string2 = loginSettings.getLoginSource();
                if (!LoginManager.isTokenLoginSource((String)string2) || StringFunctions.isEmpty((String)(string = loginSettings.getAdditionalData()))) continue;
                try {
                    TokenLoginData tokenLoginData = (TokenLoginData)json.fromJson(string, TokenLoginData.class);
                    String string3 = null;
                    TokenFieldValueData tokenFieldValueData = TokenFieldValueData.from(string2, loginSettings.getLoginID(), string3, loginSettings.getDisplayName(), tokenLoginData.getPermissions(), tokenLoginData.getLastUsed());
                    arrayList.add(tokenFieldValueData);
                }
                catch (Throwable throwable) {
                    UsersAndGroups.LOGGER.error((Object)("Corrupted token login data at user " + userAccount.getID().toString()));
                }
            }
        }
        return arrayList;
    }

    public List<TokenFieldValueData> b(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        List list = null;
        try {
            list = (List)new Json().fromJson(string, List.class, new Type[]{TokenFieldValueData.class});
        }
        catch (JsonException | ClassCastException throwable) {
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
        }
        return list;
    }

    public void save(UserAccount userAccount, UserUpdateData userUpdateData, Object values) {
        List list = (List)values;
        List list2 = userAccount != null ? userAccount.getLoginSettings() : Collections.emptyList();
        Map map = list2.stream().filter(loginSettings -> LoginManager.isTokenLoginSource((String)loginSettings.getLoginSource())).collect(Collectors.toMap(LoginSettings::getLoginID, Function.identity()));
        Json json = new Json();
        block8: for (TokenFieldValueData tokenFieldValueData : list) {
            TokenLoginData tokenLoginData;
            String string;
            String string2 = tokenFieldValueData.getLoginSource();
            String string3 = tokenFieldValueData.getTokenId();
            String string4 = tokenFieldValueData.getDescription();
            String string5 = tokenFieldValueData.getToken();
            LoginSettings loginSettings2 = (LoginSettings)map.get(string3);
            switch (string2) {
                case "bearer": {
                    if (string5 != null) {
                        string = PasswordHashing.hash((char[])string5.substring(25).toCharArray());
                        break;
                    }
                    if (loginSettings2 == null) continue block8;
                    tokenLoginData = (TokenLoginData)json.fromJson(loginSettings2.getAdditionalData(), TokenLoginData.class);
                    string = tokenLoginData.getHash();
                    break;
                }
                case "hmac": {
                    if (string5 != null) {
                        string = new String(Base64.getDecoder().decode(string5), StandardCharsets.ISO_8859_1);
                        if (loginSettings2 != null) {
                            userUpdateData.addRemovedLoginSettings(loginSettings2);
                        }
                        if (Objects.equals(string4, string3)) {
                            string4 = null;
                        }
                        string3 = string5.substring(0, string5.length() / 2);
                        break;
                    }
                    if (loginSettings2 == null) continue block8;
                    tokenLoginData = (TokenLoginData)json.fromJson(loginSettings2.getAdditionalData(), TokenLoginData.class);
                    string = tokenLoginData.getHash();
                    break;
                }
                default: {
                    throw new InternalError(string2);
                }
            }
            Object object = new TokenLoginData(string, tokenFieldValueData.getPermissions());
            ((TokenLoginData)object).setLastUsed(tokenFieldValueData.getLastUsed());
            String string6 = json.toJson(object);
            tokenLoginData = new LoginSettings(string2, string3, string6, string4);
            userUpdateData.addAddedLoginSettings((LoginSettings)tokenLoginData);
        }
        for (TokenFieldValueData tokenFieldValueData : map.values()) {
            if (this.a(list, (LoginSettings)tokenFieldValueData)) continue;
            userUpdateData.addRemovedLoginSettings((LoginSettings)tokenFieldValueData);
        }
        ForkJoinPool.commonPool().execute(() -> com.inet.authentication.token.server.a.c.d());
    }

    private boolean a(List<TokenFieldValueData> list, LoginSettings loginSettings) {
        for (TokenFieldValueData tokenFieldValueData : list) {
            if (!Objects.equals(tokenFieldValueData.getTokenId(), loginSettings.getLoginID())) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable(UserAccount userAccount) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{TokenAuthenticationServerPlugin.TOKEN_AUTHENTICATION_PERMISSION});
    }

    public String getDescription() {
        return null;
    }

    public TranslationKey getLabelTranslationKey() {
        return null;
    }

    public /* synthetic */ Object convertFromString(String string) {
        return this.b(string);
    }
}

