/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.token.server.bearer;

import com.inet.authentication.ActiveAuthenticationProvider;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.TokenAuthenticationProvider;
import com.inet.authentication.token.TokenAuthenticationServerPlugin;
import com.inet.authentication.token.server.bearer.TokenLoginData;
import com.inet.config.Configuration;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.PasswordHashing;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
implements ActiveAuthenticationProvider,
AuthenticationProvider,
TokenAuthenticationProvider {
    @Nonnull
    public String name() {
        return "bearer";
    }

    public int getPriority() {
        return 10000;
    }

    @Nonnull
    public LoginProcessor create(AuthenticationDescription description) {
        throw new UnsupportedOperationException();
    }

    public LoginProcessor createLoginProcessor(AuthenticationDescription description, @Nullable String authorization, HttpServletRequest request, boolean isApplication) {
        if (authorization == null) {
            return null;
        }
        if (authorization.startsWith("Bearer ") && authorization.length() > 40) {
            String string = authorization.substring(7, 32);
            char[] cArray = authorization.substring(32).toCharArray();
            UserManager userManager = UserManager.getInstance();
            UserAccount userAccount = userManager.findActiveUserAccount("bearer", string);
            if (userAccount != null) {
                int n;
                if (!SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{TokenAuthenticationServerPlugin.TOKEN_AUTHENTICATION_PERMISSION})) {
                    return null;
                }
                String string2 = request.getRequestURI();
                String string3 = EncodingFunctions.decodeUrlPath((String)string2.substring(n = ServletUtils.getContextPathLength((HttpServletRequest)request)));
                if (string3.isEmpty()) {
                    return null;
                }
                for (LoginSettings loginSettings : userAccount.getLoginSettings()) {
                    String string4;
                    TokenLoginData tokenLoginData;
                    if (!"bearer".equals(loginSettings.getLoginSource()) || !string.equalsIgnoreCase(loginSettings.getLoginID()) || !PasswordHashing.isMatching((String)(tokenLoginData = (TokenLoginData)new Json().fromJson(string4 = loginSettings.getAdditionalData(), TokenLoginData.class)).getHash(), (char[])cArray)) continue;
                    return com.inet.authentication.token.server.a.c.a(tokenLoginData, string3, string, userAccount.getID(), "bearer");
                }
            }
        }
        return null;
    }

    @Nonnull
    public String getDisplayName(@Nullable Map<String, String> settings) {
        return TokenAuthenticationServerPlugin.MSG.getMsg("bearer.logins.displayName", new Object[0]);
    }

    public AuthenticationDescription getAuthenticationDescription(Map<String, String> settings, boolean isApplication, boolean isProxy) {
        if (isApplication) {
            settings.put("icon", com.inet.authentication.token.server.a.class.getResource("token.png").toString());
            settings.put("color", "#46be94");
            return new AuthenticationDescription((AuthenticationProvider)this, settings, "bearer", AuthenticationDescription.BasicSupport.No);
        }
        return null;
    }

    @Nonnull
    public Map<String, String> applySettings(@Nonnull Map<String, String> clientProperties, @Nonnull Configuration config, @Nonnull List<Map<String, String>> originalInConfig) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return hashMap;
    }

    public boolean hasAdditionalConfigurationAction() {
        return false;
    }
}

