/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.token.server.hmac;

import com.inet.authentication.ActiveAuthenticationProvider;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.TokenAuthenticationProvider;
import com.inet.authentication.token.TokenAuthenticationServerPlugin;
import com.inet.authentication.token.server.bearer.TokenLoginData;
import com.inet.config.Configuration;
import com.inet.http.servlet.UploadLimitFilter;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class a
implements ActiveAuthenticationProvider,
AuthenticationProvider,
TokenAuthenticationProvider {
    private HashMap<byte[], a> i;

    public a() {
        com.inet.authentication.token.server.a.c.a(() -> {
            this.i = null;
        });
    }

    @Nonnull
    public String name() {
        return "hmac";
    }

    public int getPriority() {
        return 10001;
    }

    @Nonnull
    public LoginProcessor create(AuthenticationDescription description) {
        throw new UnsupportedOperationException();
    }

    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="runtime is not important because it is a loop")
    public LoginProcessor createLoginProcessor(AuthenticationDescription description, @Nullable String authorization, HttpServletRequest request, boolean isApplication) {
        if (authorization == null) {
            return null;
        }
        if (authorization.startsWith("HMAC ")) {
            byte[] byArray;
            try {
                byArray = Base64.getDecoder().decode(authorization.substring(5));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LoginProcessor.LOGGER.debug((Object)("HMAC hash is not a valid base64: " + authorization));
                return null;
            }
            Set<Map.Entry<byte[], a>> set = this.f().entrySet();
            if (set.isEmpty()) {
                return null;
            }
            String string = request.getServletPath();
            if (StringFunctions.isEmpty((String)string)) {
                string = request.getPathInfo();
            }
            if (string == null) {
                return null;
            }
            try {
                byte[] byArray2 = a.a((ServletRequest)request);
                for (Map.Entry<byte[], a> entry : set) {
                    byte[] byArray3 = a.a(entry.getKey(), byArray2);
                    if (!Arrays.equals(byArray, byArray3)) continue;
                    a a2 = entry.getValue();
                    TokenLoginData tokenLoginData = a2.l;
                    String string2 = a2.k;
                    return com.inet.authentication.token.server.a.c.a(tokenLoginData, string, string2, a2.j, "hmac");
                }
                LoginProcessor.LOGGER.debug((Object)("HMAC hash does not match any known HMAC token: " + authorization));
            }
            catch (Exception exception) {
                LoginProcessor.LOGGER.error((Throwable)exception);
            }
        }
        return null;
    }

    private static byte[] a(ServletRequest servletRequest) throws IOException {
        while (servletRequest instanceof HttpServletRequestWrapper) {
            if (servletRequest.getClass() == UploadLimitFilter.PreviewHttpServletRequest.class) {
                return ((UploadLimitFilter.PreviewHttpServletRequest)servletRequest).getDataPreview();
            }
            servletRequest = ((HttpServletRequestWrapper)servletRequest).getRequest();
        }
        return null;
    }

    private static byte[] a(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(byArray, "HmacSHA256"));
        return mac.doFinal(byArray2);
    }

    @Nonnull
    private HashMap<byte[], a> f() {
        HashMap<Object, a> hashMap = this.i;
        if (hashMap == null) {
            hashMap = new HashMap();
            IndexSearchEngine indexSearchEngine = UserManager.getInstance().getSearchEngine();
            AndSearchExpression andSearchExpression = new AndSearchExpression();
            andSearchExpression.add((SearchExpression)new SearchCondition("loginsettings", SearchCondition.SearchTermOperator.StartsWith, (Object)"hmac|"));
            andSearchExpression.add((SearchExpression)new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagActive.valueAsString((boolean)true)));
            Set set = indexSearchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{andSearchExpression}));
            for (GUID gUID : set) {
                UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
                if (userAccount == null || !SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{TokenAuthenticationServerPlugin.TOKEN_AUTHENTICATION_PERMISSION})) continue;
                for (LoginSettings loginSettings : userAccount.getLoginSettings()) {
                    if (!"hmac".equals(loginSettings.getLoginSource())) continue;
                    String string = loginSettings.getAdditionalData();
                    a a2 = new a();
                    a2.j = gUID;
                    a2.k = loginSettings.getLoginID();
                    TokenLoginData tokenLoginData = a2.l = (TokenLoginData)new Json().fromJson(string, TokenLoginData.class);
                    byte[] byArray = tokenLoginData.getHash().getBytes(StandardCharsets.ISO_8859_1);
                    hashMap.put(byArray, a2);
                }
            }
            this.i = hashMap;
        }
        return hashMap;
    }

    @Nonnull
    public String getDisplayName(@Nullable Map<String, String> settings) {
        return TokenAuthenticationServerPlugin.MSG.getMsg("hmac.logins.displayName", new Object[0]);
    }

    public AuthenticationDescription getAuthenticationDescription(Map<String, String> settings, boolean isApplication, boolean isProxy) {
        if (isApplication) {
            settings.put("icon", com.inet.authentication.token.server.a.class.getResource("token.png").toString());
            settings.put("color", "#46be94");
            return new AuthenticationDescription((AuthenticationProvider)this, settings, "hmac", AuthenticationDescription.BasicSupport.No);
        }
        return null;
    }

    @Nonnull
    public Map<String, String> applySettings(@Nonnull Map<String, String> clientProperties, @Nonnull Configuration config, @Nonnull List<Map<String, String>> originalInConfig) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return hashMap;
    }

    public boolean hasAdditionalConfigurationAction() {
        return false;
    }

    private class a {
        private GUID j;
        private String k;
        private TokenLoginData l;

        private a() {
        }
    }
}

