/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.product;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.base.BasicLoginProcessor;
import com.inet.authentication.base.LoginApiAccessor;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.PasswordHashing;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagLoginSettings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends BasicLoginProcessor {
    private String b;

    public b(AuthenticationDescription authenticationDescription) {
        super(authenticationDescription);
    }

    @Nullable
    public String getLoginID() {
        return this.b;
    }

    @Nonnull
    public String getLoginSource() {
        return "product";
    }

    public boolean supportsRoles() {
        return false;
    }

    public boolean isWebUserInRole(String role) {
        return false;
    }

    protected boolean transferClientLoginData(@Nonnull String username, @Nonnull String password, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws Exception {
        if (StringFunctions.isEmpty((String)username)) {
            return true;
        }
        char[] cArray = password.toCharArray();
        UserManager userManager = UserManager.getInstance();
        UserAccount userAccount = userManager.findActiveUserAccount("product", username);
        if (userAccount != null) {
            if (this.a(username, cArray, userAccount)) {
                this.b = username;
            }
        } else {
            String string = SearchTagLoginSettings.settingsAsToken((String)this.getLoginSource(), (String)username);
            SearchCondition searchCondition = new SearchCondition("loginsettings", SearchCondition.SearchTermOperator.Equals, (Object)string);
            SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{searchCondition});
            SearchResult searchResult = userManager.getSearchEngine().search(searchCommand);
            List list = searchResult.getEntries();
            for (SearchResultEntry searchResultEntry : list) {
                userAccount = userManager.getUserAccount((GUID)searchResultEntry.getId());
                if (userAccount == null || !this.a(username, cArray, userAccount)) continue;
                throw new ClientMessageException(LoginApiAccessor.I18N.getMsg("user.deactivated", new Object[]{username}));
            }
        }
        return true;
    }

    private boolean a(@Nonnull String string, char[] cArray, @Nonnull UserAccount userAccount) {
        for (LoginSettings loginSettings : userAccount.getLoginSettings()) {
            if (!this.isSameAccount(string, cArray, loginSettings)) continue;
            return true;
        }
        return false;
    }

    public boolean isSameAccount(@Nonnull String loginID, char[] passwordChars, LoginSettings login) {
        return super.isSameAccount(loginID, passwordChars, login) && PasswordHashing.isMatching((String)login.getAdditionalData(), (char[])passwordChars);
    }
}

