/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.passwordfile;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PasswordFile {
    private String passwordFile;
    private Map<String, String> map = new HashMap<String, String>();
    private String previousFilePath = null;
    private long previousLastModified = -1L;

    void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public synchronized String getHashValueOfA1(String userName, String realm) throws IOException {
        try {
            this.loadData();
        }
        catch (IOException ex) {
            this.map.clear();
            this.previousFilePath = null;
            this.previousLastModified = -1L;
            throw ex;
        }
        return this.map.get(userName + ":" + realm);
    }

    private void loadData() throws IOException {
        String filePath = this.passwordFile;
        Path passwordFile = Paths.get(filePath, new String[0]);
        long lastModified = passwordFile.toFile().lastModified();
        if (this.previousFilePath != null && this.previousFilePath.equals(filePath) && this.previousLastModified == lastModified) {
            return;
        }
        this.map.clear();
        List<String> allLines = Files.readAllLines(passwordFile, StandardCharsets.UTF_8);
        for (String line : allLines) {
            int index = line.lastIndexOf(":");
            if (index <= 0 || index == line.length() - 1) continue;
            String key = line.substring(0, index);
            String value = line.substring(index + 1);
            this.map.put(key, value);
        }
        this.previousFilePath = filePath;
        this.previousLastModified = lastModified;
    }
}

