/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.authentication.passwordfile;

/*
    either expressed or implied, including, but not limited to, the implied warranties
    of merchantability and/or fitness for a particular purpose. This programming example
    assumes that you are familiar with the programming language being demonstrated and
    the tools used to create and debug procedures. i-net software support professionals
    can help explain the functionality of a particular procedure, but they will not modify
    these examples to provide added functionality or construct procedures to meet your
    specific needs.
    © i-net software 1998-2017
*/
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.passwordfile.structure.PasswordFileAuthStructureProvider;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;

/**
 * Server plugin to register the extension
 */
@PluginInfo( //
id = "authentication.passwordfile", //
version = "25.10.233", //
group = "samples", //
icon = "com/inet/authentication/passwordfile/passwordfile_48.png" //
)
public class PasswordFileAuthServerPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        spm.register( AuthenticationProvider.class, new PasswordFileAuthProvider() );
        spm.register( ConfigStructureProvider.class, new PasswordFileAuthStructureProvider() );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
