# Digest Access Authentication  with Password File

This sample plugin can be helpful if you want to use Digest Access Authentication with a password file.

The password file used by the sample plugin can be created and updated manually using the text editor of your choice or with the `htdigest` utility that comes with Apache HTTP Server.

Each line of the password file should represent data of a single user, i.e. username, realm and MD5 hash value of the username, realm and password (concatenated with colon). The realm is defined in RFC 2617 as "A string to be displayed to users so they know which username and password to use." If this sample plugin is running with INETAPP, the realm is set to `INETAPP`.

For example, the following line from the password file `bob:INETAPP:253e2ac5a9c0c3d0fc0a5092ba886cec` represents data of user `bob` with password `xxx` in the realm of `INETAPP` where `253e2ac5a9c0c3d0fc0a5092ba886cec` is the MD5 hash value of `bob:INETAPP:xxx`.

The provided `passwdfile.txt` is an example password file containing data of users who each have the password `catch22`.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some adaptions, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin, the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `jakarta.servlet-api.jar` (included in the `core` directory)
  * `jakarta.websocket-api.jar` (included in the `core` directory)
  * `jakarta.websocket-client-api.jar` (included in the `core` directory)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `authentication.passwordfile.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `authentication.passwordfile.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configures the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin - but of course, any other build system will work just as well.

## Deploying

In order to test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details. The "Config" logger is used to log plugin registration issues.

If everything is ok you can configure the plugin in the dialog "Logins" of the configuration manager. Add the login type "Password File" and set the location of your password file.

