/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.passwordfile;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.passwordfile.PasswordFile;
import com.inet.authentication.passwordfile.PasswordFileAuthWUI;
import com.inet.config.Configuration;
import com.inet.http.servlet.ClientLocale;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PasswordFileAuthProvider
implements AuthenticationProvider {
    public static final String NAME = "passwordfile";
    private final PasswordFile passwordFile = new PasswordFile();

    @Nonnull
    public String name() {
        return NAME;
    }

    public int getPriority() {
        return 444;
    }

    @Nonnull
    public LoginProcessor create(AuthenticationDescription description) {
        String path = (String)description.getSettings().get("passwordfile.path");
        this.passwordFile.setPasswordFile(path);
        return new PasswordFileAuthWUI(description, this.passwordFile);
    }

    @Nonnull
    public String getDisplayName(@Nullable Map<String, String> settings) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.inet.authentication.passwordfile.structure.i18n.ConfigStructure", ClientLocale.getThreadLocale());
            return bundle.getString(this.name());
        }
        catch (MissingResourceException ex) {
            return this.name();
        }
    }

    public AuthenticationDescription getAuthenticationDescription(@Nonnull Map<String, String> settings, boolean isApplication, boolean isProxy) {
        return new AuthenticationDescription((AuthenticationProvider)this, settings, this.name(), AuthenticationDescription.BasicSupport.No);
    }

    public LoginProcessor createLoginProcessor(AuthenticationDescription description, @Nullable String authorization, HttpServletRequest request, boolean isApplication) {
        if (authorization == null || !authorization.startsWith("Digest ")) {
            return null;
        }
        return this.create(description);
    }

    @Nonnull
    public Map<String, String> applySettings(Map<String, String> clientProperties, Configuration config, @Nonnull List<Map<String, String>> originalInConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("passwordfile.path", clientProperties.get("passwordfile.path"));
        return result;
    }
}

