/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.passkeys.server.handler;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.SuppressFBWarnings;

@JsonData
public class PasskeyGetCredentialsResponse {
    private String challenge;
    private String rpId;

    private PasskeyGetCredentialsResponse() {
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="Setting the challenge in the session. It is created internally.")
    public static PasskeyGetCredentialsResponse forLogin(HttpServletRequest request) throws MalformedURLException {
        PasskeyGetCredentialsResponse passkeyGetCredentialsResponse = new PasskeyGetCredentialsResponse();
        URL uRL = new URL(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request).toString());
        passkeyGetCredentialsResponse.rpId = uRL.getHost();
        passkeyGetCredentialsResponse.challenge = GUID.generateNew().toString();
        request.getSession().setAttribute("passkeys.challenge", (Object)passkeyGetCredentialsResponse.challenge);
        return passkeyGetCredentialsResponse;
    }
}

