/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.passkeys.server.handler;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.id.GUID;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

@JsonData
public class PasskeySignupCredentialsResponse {
    private String challenge;
    private List<CredentialParam> pubKeyCredParams = List.of(CredentialParam.from(-7), CredentialParam.from(-257));
    private WebauthnUser user;
    private Map<String, String> rp;
    @JsonExcludeNull
    private List<CredentialParam> excludeCredentials;

    private PasskeySignupCredentialsResponse() {
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="Setting the challenge in the session. It is created internally.")
    public static PasskeySignupCredentialsResponse from(HttpServletRequest request, String username) throws MalformedURLException {
        PasskeySignupCredentialsResponse passkeySignupCredentialsResponse = new PasskeySignupCredentialsResponse();
        URL uRL = new URL(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request).toString());
        passkeySignupCredentialsResponse.rp = Map.of("name", uRL.getHost(), "id", uRL.getHost());
        passkeySignupCredentialsResponse.challenge = GUID.generateNew().toString();
        request.getSession().setAttribute("passkeys.challenge", (Object)passkeySignupCredentialsResponse.challenge);
        passkeySignupCredentialsResponse.user = WebauthnUser.from(username);
        return passkeySignupCredentialsResponse;
    }

    @JsonData
    public static class CredentialParam {
        private String type;
        @JsonExcludeNull
        private int alg;
        @JsonExcludeNull
        private String id;

        private CredentialParam() {
        }

        public static CredentialParam from(int algorithm) {
            CredentialParam credentialParam = new CredentialParam();
            credentialParam.type = "public-key";
            credentialParam.alg = algorithm;
            return credentialParam;
        }

        public static CredentialParam from(String id) {
            CredentialParam credentialParam = new CredentialParam();
            credentialParam.type = "public-key";
            credentialParam.id = id;
            return credentialParam;
        }
    }

    @JsonData
    public static class WebauthnUser {
        @JsonExcludeNull
        private String displayName;
        private String name;
        private GUID id;

        private WebauthnUser() {
        }

        public static WebauthnUser from(String username) {
            WebauthnUser webauthnUser = new WebauthnUser();
            webauthnUser.id = GUID.generateNew();
            webauthnUser.name = username;
            webauthnUser.displayName = username;
            return webauthnUser;
        }
    }
}

