/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.pam.libpam;

import com.inet.authentication.LoginProcessor;
import com.inet.authentication.pam.libpam.PAMException;
import com.inet.authentication.pam.libpam.UnixUser;
import com.inet.authentication.pam.libpam.impl.CLibrary;
import com.inet.authentication.pam.libpam.impl.PAMLibrary;
import com.inet.logging.Logger;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.Set;

public class PAM {
    private static final Logger LOGGER = LoginProcessor.LOGGER;
    private static final Object MUTEX = new Object();
    private PAMLibrary.pam_handle_t pht;
    private PAMLibrary.pam_conv conv = new PAMLibrary.pam_conv(new PAMLibrary.pam_conv.PamCallback(){

        @Override
        public int callback(int num_msg, Pointer msg, Pointer resp, Pointer __) {
            LOGGER.debug((Object)("pam_conv num_msg=" + num_msg));
            if (PAM.this.password == null) {
                return 6;
            }
            Pointer m = CLibrary.libc.calloc(PAMLibrary.pam_response.SIZE, num_msg);
            resp.setPointer(0L, m);
            for (int i = 0; i < num_msg; ++i) {
                PAMLibrary.pam_message pm = new PAMLibrary.pam_message(msg.getPointer((long)(Native.POINTER_SIZE * i)));
                LOGGER.debug((Object)(pm.msg_style + ":" + pm.msg));
                if (pm.msg_style != 1) continue;
                PAMLibrary.pam_response r = new PAMLibrary.pam_response(m.share((long)(PAMLibrary.pam_response.SIZE * i)));
                r.setResp(PAM.this.password);
                r.write();
            }
            return 0;
        }
    });
    private int ret;
    private String password;

    public PAM(String serviceName) throws PAMException {
        PointerByReference phtr = new PointerByReference();
        this.check(PAMLibrary.libpam.pam_start(serviceName, null, this.conv, phtr), "pam_start failed");
        this.pht = new PAMLibrary.pam_handle_t(phtr.getValue());
    }

    private void check(int ret, String msg) throws PAMException {
        this.ret = ret;
        if (ret != 0) {
            if (this.pht != null) {
                throw new PAMException(msg + " : " + PAMLibrary.libpam.pam_strerror(this.pht, ret));
            }
            throw new PAMException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnixUser authenticate(String username, String password) throws PAMException {
        this.password = password;
        try {
            LOGGER.debug((Object)"pam_set_item PAM_TTY console");
            this.check(PAMLibrary.libpam.pam_set_item(this.pht, 3, "console"), "pam_set_item for tty failed");
            LOGGER.debug((Object)("pam_set_item PAM_USER " + username));
            this.check(PAMLibrary.libpam.pam_set_item(this.pht, 2, username), "pam_set_item for user failed");
            LOGGER.debug((Object)"pam_authenticate");
            Object object = MUTEX;
            synchronized (object) {
                this.check(PAMLibrary.libpam.pam_authenticate(this.pht, 0), "pam_authenticate failed");
            }
            PointerByReference r = new PointerByReference();
            this.check(PAMLibrary.libpam.pam_get_item(this.pht, 2, r), "pam_get_item failed");
            String userName = r.getValue().getString(0L);
            CLibrary.passwd pwd = CLibrary.libc.getpwnam(userName);
            if (pwd == null) {
                throw new PAMException("Authentication succeeded but no user information is available");
            }
            Object loggedInName = pwd.getPwName();
            if (username.toLowerCase().endsWith(((String)loggedInName).toLowerCase())) {
                loggedInName = username.substring(0, username.length() - ((String)loggedInName).length()).toUpperCase() + (String)loggedInName;
            }
            UnixUser unixUser = new UnixUser((String)loggedInName, pwd);
            return unixUser;
        }
        finally {
            this.password = null;
        }
    }

    public Set<String> getGroupsOfUser(String username) throws PAMException {
        return new UnixUser(username).getGroups();
    }

    public void dispose() {
        if (this.pht != null) {
            PAMLibrary.libpam.pam_end(this.pht, this.ret);
            this.pht = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

