/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.pam;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.SystemAuthenticationProvider;
import com.inet.authentication.base.BasicAuthenticationProvider;
import com.inet.authentication.base.LoginApiAccessor;
import com.inet.authentication.pam.PamLoginProcessor;
import com.inet.config.Configuration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PamAuthenticationProvider
extends BasicAuthenticationProvider
implements SystemAuthenticationProvider {
    @Nonnull
    public String name() {
        return "pam";
    }

    public int getPriority() {
        return 200;
    }

    @Nonnull
    public LoginProcessor create(AuthenticationDescription description) {
        return new PamLoginProcessor(description);
    }

    @Nonnull
    public String getDisplayName(@Nullable Map<String, String> settings) {
        return LoginApiAccessor.I18N.getMsg(this.name(), new Object[0]);
    }

    @Nonnull
    public Map<String, String> applySettings(@Nonnull Map<String, String> clientProperties, @Nonnull Configuration config, @Nonnull List<Map<String, String>> originalInConfig) {
        return new HashMap<String, String>();
    }

    @Nullable
    public AuthenticationDescription getAuthenticationDescription(Map<String, String> settings, boolean isApplication, boolean isProxy) {
        settings.put("icon", ((Object)((Object)this)).getClass().getResource("/com/inet/authentication/pam/pam.png").toString());
        settings.put("color", "#2b866c");
        return super.getAuthenticationDescription(settings, isApplication, isProxy);
    }
}

