/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.pam.libpam.impl;

import com.inet.authentication.pam.libpam.impl.CLibrary;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;

public interface PAMLibrary
extends Library {
    public static final int PAM_USER = 2;
    public static final int PAM_TTY = 3;
    public static final int PAM_SUCCESS = 0;
    public static final int PAM_CONV_ERR = 6;
    public static final int PAM_PROMPT_ECHO_OFF = 1;
    public static final int PAM_PROMPT_ECHO_ON = 2;
    public static final int PAM_ERROR_MSG = 3;
    public static final int PAM_TEXT_INFO = 4;
    public static final PAMLibrary libpam = (PAMLibrary)Native.loadLibrary((String)"pam", PAMLibrary.class);

    public int pam_start(String var1, String var2, pam_conv var3, PointerByReference var4);

    public int pam_end(pam_handle_t var1, int var2);

    public int pam_set_item(pam_handle_t var1, int var2, String var3);

    public int pam_get_item(pam_handle_t var1, int var2, PointerByReference var3);

    public int pam_authenticate(pam_handle_t var1, int var2);

    public int pam_setcred(pam_handle_t var1, int var2);

    public int pam_acct_mgmt(pam_handle_t var1, int var2);

    public String pam_strerror(pam_handle_t var1, int var2);

    public static class pam_conv
    extends Structure {
        public PamCallback conv;
        public Pointer __;

        public pam_conv(PamCallback conv) {
            this.conv = conv;
        }

        protected List getFieldOrder() {
            return Arrays.asList("conv", "__");
        }

        public static interface PamCallback
        extends Callback {
            public int callback(int var1, Pointer var2, Pointer var3, Pointer var4);
        }
    }

    public static class pam_response
    extends Structure {
        public Pointer resp;
        public int resp_retcode;
        public static final int SIZE = new pam_response().size();

        public pam_response(Pointer src) {
            this.useMemory(src);
            this.read();
        }

        public pam_response() {
        }

        public void setResp(String msg) {
            this.resp = CLibrary.libc.strdup(msg);
        }

        protected List getFieldOrder() {
            return Arrays.asList("resp", "resp_retcode");
        }
    }

    public static class pam_message
    extends Structure {
        public int msg_style;
        public String msg;

        public pam_message(Pointer src) {
            this.useMemory(src);
            this.read();
        }

        protected List getFieldOrder() {
            return Arrays.asList("msg_style", "msg");
        }
    }

    public static class pam_handle_t
    extends PointerType {
        public pam_handle_t() {
        }

        public pam_handle_t(Pointer pointer) {
            super(pointer);
        }
    }
}

