/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.pam;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginRoles;
import com.inet.authentication.base.BasicLoginProcessor;
import com.inet.authentication.pam.libpam.PAM;
import com.inet.authentication.pam.libpam.PAMException;
import com.inet.authentication.pam.libpam.UnixUser;
import com.inet.error.ErrorCode;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only known file pathes")
public class PamLoginProcessor
extends BasicLoginProcessor
implements LoginRoles {
    private static final String SERVICE;
    private static final Exception INIT_EXCPETION;
    private String userName;
    private Set<String> groups;

    public PamLoginProcessor(AuthenticationDescription description) {
        super(description);
        if (INIT_EXCPETION != null) {
            ErrorCode.throwAny((Throwable)INIT_EXCPETION);
        }
    }

    @Nonnull
    public String getLoginSource() {
        return "system";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean transferClientLoginData(String username, String password, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        PAM pam = null;
        try {
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)("authenticate " + username + " via pam"));
            }
            pam = new PAM(SERVICE);
            UnixUser user = pam.authenticate(username, password);
            this.userName = user.getUserName();
            this.groups = user.getGroups();
            boolean bl = true;
            return bl;
        }
        catch (PAMException ex) {
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)ex);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (pam != null) {
                pam.dispose();
            }
        }
    }

    public void requestLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.userName = null;
        super.requestLoginData(httpRequest, httpResponse);
    }

    public String getLoginID() {
        return this.userName;
    }

    public boolean supportsRoles() {
        return true;
    }

    public boolean isWebUserInRole(String role) {
        if (this.groups != null) {
            for (String group2 : this.groups) {
                if (!role.equalsIgnoreCase(group2)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public Set<String> getRoles() {
        return this.groups;
    }

    static {
        String service = null;
        Exception exception = null;
        try {
            String pluginID = ServerPluginManager.getInstance().getCorePluginId();
            if (new File("/etc/pam.d/" + pluginID).exists()) {
                service = pluginID;
            } else if (new File("/etc/pam.d/login").exists()) {
                service = "login";
                LOGGER.warn((Object)("Fall back to pam 'login'. Create a file /etc/pam.d/" + pluginID + " if you want a specific pam configurration."));
            } else if (new File("/etc/pam.d/chkpasswd").exists()) {
                service = "chkpasswd";
                LOGGER.warn((Object)("Fall back to pam 'chkpasswd'. Create a file /etc/pam.d/" + pluginID + " if you want a specific pam configurration."));
            } else if (new File("/etc/pam.d/passwd").exists()) {
                service = "passwd";
                LOGGER.warn((Object)("Fall back to pam 'passwd'. Create a file /etc/pam.d/" + pluginID + " if you want a specific pam configurration."));
            } else if (new File("/etc/pam.d/common-auth").exists()) {
                service = "common-auth";
                LOGGER.warn((Object)("Fall back to pam 'common-auth'. Create a file /etc/pam.d/" + pluginID + " if you want a specific pam configurration."));
            } else {
                throw new IllegalStateException("Pam configuration '/etc/pam.d/" + pluginID + "' or '/etc/pam.d/passwd' not found.");
            }
            if (!new File("/etc/shadow").canRead()) {
                LOGGER.warn((Object)("PAM authentication of local users is not possible due to missing read permissions to /etc/shadow. Please execute enable-pam-for-user.sh in the installation directory to use this feature. Enter '" + System.getProperty("user.name") + "' as user name when requested."));
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        SERVICE = service;
        INIT_EXCPETION = exception;
    }
}

