/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.oauth.ex;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.oauth2.api.OAuthServerDescription;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nonnull;

public class OAuthExServerDescription
implements OAuthServerDescription {
    static final String NAME = "supergit";
    static final String OAUTH_AUTHENTICATION_URL = "supergit.authentication.server";
    static final String OAUTH_TOKEN_URL = "supergit.token.server";
    static final String OAUTH_USERINFO_URL = "supergit.userinfo.server";

    @Nonnull
    public String name() {
        return NAME;
    }

    @Nonnull
    public String getAuthenticationURL(@Nonnull AuthenticationDescription config) {
        return (String)config.getSettings().get(OAUTH_AUTHENTICATION_URL);
    }

    public String getTokenURL(@Nonnull AuthenticationDescription config) {
        return (String)config.getSettings().get(OAUTH_TOKEN_URL);
    }

    public URLConnection getDataConnection(@Nonnull AuthenticationDescription config, String accessToken) throws IOException {
        URL url = new URL((String)config.getSettings().get(OAUTH_USERINFO_URL));
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        return conn;
    }
}

