# OAuth Authentication

This sample plugin can be helpful if you want to use an OAuth service that is not supported by default.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some adaptions, please refer to the platform programming guide for detailed instructions. In order to test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the Store application. If there are problems, then check the log file of the server for more details.

### Collect the required jar files

In order to build this plugin, the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `authentication.oauth.jar` (included in `plugins/authentication.oauth.zip`)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `authentication.ouath.ex.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `authentication.ouath.ex.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configures the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin - but of course, any other build system will work just as well.

## Deploying

Copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the Store application. If there are problems, then check the log file of the server for more details. The "Config" logger is used to log plugin registration issues.

If everything is ok you can configure the plugin in the dialog "Logins" of the configuration manager. Add the login type "*OAuth*". In the popup select "*openid*" and enter the 2 URLs for your OAuth provider.

