/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.oauth.ex;

import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuthExStructureProvider
extends AbstractStructureProvider {
    private static final String GROUP_OAUTH = "oauth.action";
    public static final OAuthExStructureProvider INSTANCE = new OAuthExStructureProvider();

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "oauth.action": {
                ConditionGenerator g = new ConditionGenerator();
                ConfigCondition condition = g.createCondition().property("logintype").equals().value((Object)"supergit");
                actions.add(g.visibleActionFor(condition, "supergit.authentication.server"));
                actions.add(g.visibleActionFor(condition, "supergit.token.server"));
                actions.add(g.visibleActionFor(condition, "supergit.userinfo.server"));
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "oauth.action": {
                configProperties.add(new ConfigProperty(150, "supergit.authentication.server", "SimpleText", "Authentication URL", (Object)"", null, null));
                configProperties.add(new ConfigProperty(160, "supergit.token.server", "SimpleText", "Token URL", (Object)"", null, null));
                configProperties.add(new ConfigProperty(160, "supergit.userinfo.server", "SimpleText", "Userinfo URL", (Object)"", null, null));
                break;
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        String loginType;
        if (GROUP_OAUTH.equals(categoryKey) && Objects.equals(loginType = settings.getValue("logintype"), "supergit")) {
            ConfigValidator validator = new ConfigValidator(messages, settings);
            validator.checkNotEmpty("supergit.authentication.server");
            validator.checkNotEmpty("supergit.token.server");
            validator.checkNotEmpty("supergit.userinfo.server");
        }
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }
}

