/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.ldap;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginRoles;
import com.inet.authentication.base.BasicLoginProcessor;
import com.inet.authentication.ldap.c;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.shared.utils.TrustAllSSLSocketFactory;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;

@SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="user input is escaped via LdapUtils.escapeLDAPSearchFilter")
public class b
extends BasicLoginProcessor
implements LoginRoles {
    private static Set<String> b;
    private final String c;
    private final Set<String> d;
    private final boolean e;
    private String f;
    private HashSet<String> g;
    private HashSet<String> h;
    private Hashtable<String, String> i;
    private String j;
    private String k;
    private String l;
    private String m;
    private String n;
    private String o;
    private String p;
    private String q;

    public b(AuthenticationDescription authenticationDescription, String string, boolean bl, String string2, String string3, String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
        super(authenticationDescription);
        this.d = com.inet.authentication.ldap.b.a(string);
        this.e = bl;
        this.c = string2 == null || string2.trim().isEmpty() ? "" : string2.trim() + "\\";
        this.m = string3;
        this.n = string4;
        this.o = string5;
        this.p = string6;
        this.q = string7;
    }

    @Nonnull
    public static Set<String> a(String string) {
        if (StringFunctions.isEmpty((String)string) || "[]".equals(string)) {
            return com.inet.authentication.ldap.b.b();
        }
        if (string.startsWith("[[")) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            List list = (List)new Json().fromJson(string, (Type)new JsonParameterizedType(List.class, new Type[]{List.class}));
            for (List list2 : list) {
                linkedHashSet.add((String)list2.get(0));
            }
            return linkedHashSet;
        }
        if (string.startsWith("[")) {
            return (Set)new Json().fromJson(string, LinkedHashSet.class);
        }
        return Collections.singleton(string);
    }

    @Nonnull
    public String getLoginSource() {
        return "system";
    }

    @Nonnull
    @SuppressFBWarnings(value={"LDAP_ANONYMOUS"}, justification="only base settings")
    public Hashtable<String, String> b(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        if (StringFunctions.isEmpty((String)this.m)) {
            hashtable.put("java.naming.security.authentication", "none");
        } else {
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", this.m);
            hashtable.put("java.naming.security.credentials", Encryption.decrypt((String)this.n));
        }
        hashtable.put("com.sun.jndi.ldap.read.timeout", "5000");
        if (this.e && string.startsWith("ldaps:")) {
            hashtable.put("java.naming.ldap.factory.socket", TrustAllSSLSocketFactory.class.getName());
        }
        hashtable.put("java.naming.ldap.attributes.binary", "objectSid");
        return hashtable;
    }

    protected boolean transferClientLoginData(@Nonnull String username, @Nonnull String password, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws Exception {
        if (password.isEmpty()) {
            this.requestLoginData(httpRequest, httpResponse);
            return false;
        }
        if (!((String)(username = ((String)username).replace('/', '\\'))).contains("\\")) {
            username = this.c + (String)username;
        }
        InitialContext initialContext = null;
        for (String string : this.d) {
            LOGGER.debug((Object)string);
            this.i = this.b(string);
            this.i.put("java.naming.security.authentication", "simple");
            this.i.put("java.naming.security.principal", (String)username);
            this.i.put("java.naming.security.credentials", password);
            try {
                initialContext = this.a();
                break;
            }
            catch (AuthenticationException authenticationException) {
                LOGGER.debug((Object)authenticationException);
                this.i = null;
                return true;
            }
            catch (CommunicationException communicationException) {
                LOGGER.debug((Object)communicationException);
                this.i = null;
            }
        }
        if (initialContext == null) {
            return true;
        }
        this.f = username;
        this.a((InitialLdapContext)initialContext);
        initialContext.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public InitialLdapContext a() throws NamingException {
        if (this.i == null) {
            throw new AuthenticationException("Authentication not done yet");
        }
        try {
            return new InitialLdapContext(this.i, null);
        }
        catch (InvalidNameException invalidNameException) {
            String string;
            String string2 = this.i.get("java.naming.security.principal");
            String[] stringArray = string2.split("\\\\", 2);
            if (stringArray.length == 2) {
                string = stringArray[0];
                string2 = stringArray[1];
            } else {
                string = null;
            }
            if (string2.contains("=")) {
                LOGGER.debug((Object)invalidNameException);
                throw new AuthenticationException("Qualified name is invalid");
            }
            Hashtable<String, String> hashtable = this.b(this.i.get("java.naming.provider.url"));
            InitialLdapContext initialLdapContext = new InitialLdapContext(hashtable, null);
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setSearchScope(2);
            boolean bl = false;
            for (String string3 : com.inet.authentication.ldap.c.a(initialLdapContext, this.o)) {
                void object;
                if (string != null && !this.a(string3, string)) continue;
                bl = true;
                if (!StringFunctions.isEmpty((String)this.p)) {
                    String string4 = this.p + "," + string3;
                }
                String string5 = "(&(objectClass=person)(uid=" + com.inet.authentication.ldap.c.d(string2) + "))";
                LOGGER.debug((Object)("LDAP search: " + string5 + " in " + (String)object));
                NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((String)object, string5, searchControls);
                if (!namingEnumeration.hasMoreElements()) continue;
                String string6 = ((SearchResult)namingEnumeration.nextElement()).getNameInNamespace();
                LOGGER.debug((Object)("Retrieved fullname via search: " + string6));
                if (string6 == null) continue;
                this.i.put("java.naming.security.principal", string6);
                InitialLdapContext initialLdapContext2 = new InitialLdapContext(this.i, null);
                if (StringFunctions.isEmpty((String)this.m)) {
                    return initialLdapContext2;
                }
                initialLdapContext2.close();
                return initialLdapContext;
            }
            if (bl) {
                throw new AuthenticationException("UID not found");
            }
            throw new AuthenticationException("No matching LDAP root found for domain: " + string);
        }
    }

    public void requestLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.f = null;
        super.requestLoginData(httpRequest, httpResponse);
    }

    public String getLoginID() {
        return this.f;
    }

    public boolean supportsRoles() {
        return true;
    }

    public boolean isWebUserInRole(String role) {
        if (this.h == null) {
            this.h = new HashSet();
            for (String string : this.getRoles()) {
                this.h.add(string.toLowerCase());
            }
        }
        return this.h.contains(role.toLowerCase());
    }

    @Nonnull
    public Set<String> getRoles() {
        if (this.g == null) {
            this.g = new HashSet();
        }
        return this.g;
    }

    private void a(InitialLdapContext initialLdapContext) {
        if (this.g == null) {
            this.g = new HashSet();
            try {
                SearchControls searchControls = new SearchControls();
                String[] stringArray = new String[]{"memberOf", "primaryGroupId", "sAMAccountName", "mail", "givenName", "sn", "objectSid", "msDS-PrincipalName"};
                searchControls.setReturningAttributes(stringArray);
                searchControls.setSearchScope(2);
                int n = this.f.indexOf(92);
                String string = n >= 0 ? this.f.substring(n + 1) : this.f;
                String string2 = n >= 0 ? this.f.substring(0, n) : null;
                SearchResult searchResult = null;
                String string3 = com.inet.authentication.ldap.c.d(string);
                String string4 = "(|(&(objectCategory=person)(sAMAccountName=" + string3 + "))(&(objectClass=person)(uid=" + string3 + "))(&(objectClass=person)(userPrincipalName=" + string3 + ")))";
                for (String string5 : com.inet.authentication.ldap.c.a(initialLdapContext, this.o)) {
                    Serializable serializable;
                    Object object;
                    HashSet<String> hashSet = new HashSet<String>();
                    Object object2 = string5;
                    if (!StringFunctions.isEmpty((String)this.p)) {
                        object2 = this.p + "," + (String)object2;
                    }
                    LOGGER.debug((Object)("LDAP search: " + string4 + " in " + (String)object2));
                    NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search((String)object2, string4, searchControls);
                    if (namingEnumeration.hasMoreElements()) {
                        Object object3;
                        NamingEnumeration<?> namingEnumeration2;
                        searchResult = (SearchResult)namingEnumeration.nextElement();
                        object = searchResult.getAttributes();
                        serializable = object.get("msDS-PrincipalName");
                        if (serializable != null) {
                            namingEnumeration2 = serializable.get();
                            if (namingEnumeration2 != null) {
                                this.f = namingEnumeration2.toString();
                            }
                        } else {
                            serializable = object.get("sAMAccountName");
                            if (serializable != null && (namingEnumeration2 = serializable.get()) != null && (object3 = com.inet.authentication.ldap.b.c(string5)) != null && ((String)object3).equalsIgnoreCase(string2)) {
                                this.f = (String)object3 + "\\" + String.valueOf(namingEnumeration2);
                            }
                        }
                        serializable = object.get("memberOf");
                        if (serializable != null) {
                            namingEnumeration2 = serializable.getAll();
                            while (namingEnumeration2.hasMoreElements()) {
                                object3 = namingEnumeration2.nextElement().toString();
                                LOGGER.debug((Object)("memberOf group: " + (String)object3));
                                hashSet.add((String)object3);
                            }
                        }
                        if ((serializable = object.get("primaryGroupId")) != null) {
                            namingEnumeration2 = serializable.get().toString();
                            serializable = object.get("objectSid");
                            if (serializable != null) {
                                object3 = (byte[])serializable.get();
                                String string6 = this.a(initialLdapContext, string5, Integer.parseInt((String)((Object)namingEnumeration2)), (byte[])object3);
                                LOGGER.debug((Object)("primaryGroup: " + string6));
                                if (string6 != null) {
                                    hashSet.add(string6);
                                }
                            }
                        }
                    } else {
                        LOGGER.debug((Object)("User data not found for: '" + string4 + "' in '" + (String)object2 + "'"));
                    }
                    Object object4 = object = string.contains("=") ? this.b(string, "uid") : string;
                    if (object != null) {
                        string4 = "(&(objectClass=posixGroup)(memberUid=" + com.inet.authentication.ldap.c.d((String)object) + "))";
                        LOGGER.debug((Object)("LDAP search: " + string4 + " in " + string5));
                        namingEnumeration = initialLdapContext.search(string5, string4, searchControls);
                        while (namingEnumeration.hasMoreElements()) {
                            serializable = (SearchResult)namingEnumeration.nextElement();
                            hashSet.add(((NameClassPair)serializable).getNameInNamespace());
                        }
                    }
                    this.a(initialLdapContext, string5, hashSet, this.g);
                }
                if (searchResult != null) {
                    this.a(searchResult);
                }
            }
            catch (Exception exception) {
                LOGGER.debug((Object)exception);
            }
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)("Groups: " + String.valueOf(this.g)));
            }
        }
    }

    private void a(@Nonnull SearchResult searchResult) throws NamingException {
        Attribute attribute;
        Attributes attributes = searchResult.getAttributes();
        String string = com.inet.authentication.ldap.b.c(searchResult.getName());
        if (string != null && !StringFunctions.isEmpty((String)string)) {
            int n = string.lastIndexOf(32);
            if (n >= 0) {
                this.j = string.substring(0, n).trim();
                this.k = string.substring(n).trim();
            } else {
                this.k = string;
            }
        }
        if ((attribute = attributes.get("givenName")) != null) {
            this.j = attribute.get().toString();
        }
        if ((attribute = attributes.get("sn")) != null) {
            this.k = attribute.get().toString();
        }
        if ((attribute = attributes.get("mail")) != null) {
            this.l = attribute.get().toString();
        }
    }

    @Nonnull
    protected MutableUserData createNewUserData() {
        MutableUserData mutableUserData = super.createNewUserData();
        if (this.l != null) {
            mutableUserData.put((UserField)UsersAndGroups.FIELD_EMAIL, (Object)this.l);
        }
        if (this.j != null) {
            mutableUserData.put((UserField)UsersAndGroups.FIELD_FIRSTNAME, (Object)this.j);
        }
        if (this.k != null) {
            mutableUserData.put((UserField)UsersAndGroups.FIELD_LASTNAME, (Object)this.k);
        }
        return mutableUserData;
    }

    private boolean a(String string, String string2) {
        if (!string.toLowerCase().startsWith("dc=")) {
            return false;
        }
        int n = string.indexOf(44);
        String string3 = n == -1 ? string.substring(3) : string.substring(3, n);
        return string3.equalsIgnoreCase(string2);
    }

    private void a(InitialLdapContext initialLdapContext, String string, Set<String> set, Set<String> set2) throws NamingException {
        SearchControls searchControls = new SearchControls();
        String[] stringArray = new String[]{"memberOf", "cn"};
        searchControls.setReturningAttributes(stringArray);
        searchControls.setSearchScope(2);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>(set);
        String string2 = StringFunctions.isEmpty((String)this.q) ? null : (this.q + "," + string).toLowerCase();
        LOGGER.debug((Object)("Using group suffix: " + string2));
        while (!hashSet2.isEmpty()) {
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                Object object;
                Attribute attribute;
                String string3 = (String)iterator.next();
                iterator.remove();
                LOGGER.debug((Object)("Fetching LDAP attributes for: " + string3));
                Attributes attributes = initialLdapContext.getAttributes(string3, stringArray);
                if (string2 == null || string3.toLowerCase().endsWith(string2)) {
                    this.a(string3, set2);
                    this.a(com.inet.authentication.ldap.b.c(string3), set2);
                    attribute = attributes.get("cn");
                    if (attribute != null) {
                        object = attribute.get().toString();
                        if (!StringFunctions.isEmpty((String)object)) {
                            this.a((String)object, set2);
                        } else {
                            LOGGER.debug((Object)("cn is empty for group " + string3));
                        }
                    } else {
                        LOGGER.debug((Object)("cn is null for group " + string3));
                    }
                }
                if ((attribute = attributes.get("memberOf")) != null) {
                    object = attribute.getAll();
                    while (object.hasMoreElements()) {
                        string3 = object.nextElement().toString();
                        if (!set.contains(string3)) {
                            LOGGER.debug((Object)("memberOf group: " + string3));
                            hashSet.add(string3);
                            set.add(string3);
                            continue;
                        }
                        LOGGER.debug((Object)("memberOf recursion found: " + string3));
                    }
                    continue;
                }
                LOGGER.debug((Object)("memberOf is null for group " + string3));
            }
            hashSet2.addAll(hashSet);
            hashSet.clear();
        }
    }

    private void a(String string, Set<String> set) {
        if (string.length() <= 100) {
            set.add(string);
        }
    }

    @Nullable
    private String b(String string, String string2) throws InvalidNameException {
        LdapName ldapName = new LdapName(string);
        String string3 = string2 + "=";
        for (int i = ldapName.size() - 1; i >= 0; --i) {
            String string4 = ldapName.get(i);
            if (!string4.toLowerCase().startsWith(string3)) continue;
            return string4.substring(string3.length());
        }
        return null;
    }

    private String a(InitialLdapContext initialLdapContext, String string, int n, byte[] byArray) throws NamingException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder("S-");
        stringBuilder.append(byArray[0]);
        int n3 = byArray[1] & 0xFF;
        long l = 0L;
        for (n2 = 2; n2 <= 7; ++n2) {
            l |= (long)byArray[n2] << 8 * (5 - (n2 - 2));
        }
        stringBuilder.append("-").append(l);
        n2 = 8;
        for (int i = 0; i < n3 - 1; ++i) {
            long l2 = 0L;
            for (int j = 0; j < 4; ++j) {
                l2 |= (long)(byArray[n2++] & 0xFF) << 8 * j;
            }
            stringBuilder.append("-").append(l2);
        }
        stringBuilder.append("-").append(n);
        String string2 = "(&(objectCategory=group)(objectSID=" + String.valueOf(stringBuilder) + "))";
        SearchControls searchControls = new SearchControls();
        String[] stringArray = new String[]{"distinguishedName"};
        searchControls.setReturningAttributes(stringArray);
        searchControls.setSearchScope(2);
        LOGGER.debug((Object)("LDAP search: " + string2 + " in " + string));
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search(string, string2, searchControls);
        if (namingEnumeration.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
            Attributes attributes = searchResult.getAttributes();
            return attributes.get("distinguishedName").get().toString();
        }
        return null;
    }

    @Nonnull
    public static Set<String> b() {
        if (b != null) {
            return b;
        }
        Set<String> set = com.inet.authentication.ldap.b.c();
        if (set.isEmpty()) {
            Object object = System.getenv("LOGONSERVER");
            object = object != null ? "ldap:" + ((String)object).replace('\\', '/') + "/" : "ldap://localhost:389/";
            set.add((String)object);
        }
        LOGGER.debug((Object)("Default LDAP urls: " + String.valueOf(set)));
        b = set;
        return b;
    }

    @Nonnull
    static Set<String> c() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            HashSet<String> hashSet = new HashSet<String>();
            InetAddress[] inetAddressArray = ConfigurationManager.getInstance().getAvailableIPAddresses();
            Map<InetAddress, String> map = ((Stream)Arrays.stream(inetAddressArray).parallel()).collect(Collectors.toMap(inetAddress -> inetAddress, inetAddress -> NetworkFunctions.getCanonicalHostName((InetAddress)inetAddress), (string, string2) -> string));
            for (Map.Entry<InetAddress, String> entry : map.entrySet()) {
                InetAddress inetAddress2 = entry.getKey();
                String string3 = entry.getValue();
                LOGGER.debug((Object)("Canonical Host Name: " + string3));
                int n = string3.indexOf(46);
                if (string3.equals(inetAddress2.getHostAddress()) || n < 0) {
                    string3 = com.inet.authentication.ldap.b.a(initialDirContext, inetAddress2);
                    LOGGER.debug((Object)("DNS PTR: " + string3));
                    n = string3.indexOf(46);
                    if (n < 0) continue;
                }
                if (!hashSet.add(string3 = string3.substring(n + 1))) continue;
                for (String string4 : new String[]{"_ldaps._tcp.", "_ldap._tcp."}) {
                    try {
                        Attributes attributes = initialDirContext.getAttributes(string4 + string3, new String[]{"SRV"});
                        if (attributes.size() == 0) continue;
                        Attribute attribute = (Attribute)attributes.getAll().nextElement();
                        NamingEnumeration<?> namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            String string5;
                            String string6;
                            String string7 = namingEnumeration.nextElement().toString();
                            String[] stringArray = string7.split(" ");
                            String string8 = stringArray[3];
                            if (string8.endsWith(".")) {
                                string8 = string8.substring(0, string8.length() - 1);
                            }
                            if (linkedHashMap.containsKey(string8)) continue;
                            if (string4.equals("_ldaps._tcp.")) {
                                string6 = "ldaps";
                                string5 = "636";
                            } else {
                                string6 = "ldap";
                                string5 = "389";
                            }
                            StringBuilder stringBuilder = new StringBuilder(string6).append("://").append(string8);
                            if (!string5.equals(stringArray[2])) {
                                stringBuilder.append(':').append(stringArray[2]);
                            }
                            stringBuilder.append('/');
                            linkedHashMap.put(string8, stringBuilder.toString());
                        }
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        LOGGER.debug((Object)nameNotFoundException);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        return new LinkedHashSet<String>(linkedHashMap.values());
    }

    private static String a(DirContext dirContext, InetAddress inetAddress) throws Exception {
        String string = inetAddress.getCanonicalHostName();
        if (!string.equals(inetAddress.getHostAddress()) && string.indexOf(46) > 0) {
            return string;
        }
        String string2 = inetAddress.getHostAddress();
        String[] stringArray = string2.split("\\.");
        if (stringArray.length != 4) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[3]).append('.');
        stringBuilder.append(stringArray[2]).append('.');
        stringBuilder.append(stringArray[1]).append('.');
        stringBuilder.append(stringArray[0]).append(".in-addr.arpa.");
        Attributes attributes = dirContext.getAttributes(stringBuilder.toString(), new String[]{"PTR"});
        return attributes.get("PTR").get().toString();
    }

    private static String c(String string) throws InvalidNameException {
        LdapName ldapName = new LdapName(string);
        Object object = null;
        Object object2 = null;
        for (int i = ldapName.size() - 1; i >= 0; --i) {
            String string2 = ldapName.get(i);
            String string3 = string2.toLowerCase();
            if (object == null && string3.startsWith("cn=")) {
                object = string2.substring(3);
                continue;
            }
            if (!string3.startsWith("dc=")) continue;
            string2 = string2.substring(3);
            if (object2 == null) {
                object2 = string2;
                continue;
            }
            if (string2.equals("local")) break;
            object2 = (String)object2 + "." + string2;
        }
        return object2 != null ? (object != null ? object2 + "\\" + object : object2) : object;
    }
}

