/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.ldap;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.SystemAuthenticationProvider;
import com.inet.authentication.base.BasicAuthenticationProvider;
import com.inet.authentication.base.LoginApiAccessor;
import com.inet.authentication.ldap.b;
import com.inet.config.Configuration;
import com.inet.lib.json.Json;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.StringFunctions;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class a
extends BasicAuthenticationProvider
implements SystemAuthenticationProvider {
    @Nonnull
    public String name() {
        return "ldap";
    }

    public int getPriority() {
        return 400;
    }

    @Nullable
    public LoginProcessor create(@Nonnull AuthenticationDescription description) {
        Map map = description.getSettings();
        String string = (String)map.get("ldap.loginurl");
        boolean bl = Boolean.parseBoolean((String)map.get("ldap.trustall"));
        String string2 = (String)map.get("ldap.default_domain");
        String string3 = (String)map.get("ldap.bind_user");
        String string4 = (String)map.get("ldap.bind_password");
        String string5 = (String)map.get("ldap.base_dn");
        String string6 = (String)map.get("ldap.user_rdn");
        String string7 = (String)map.get("ldap.group_rdn");
        return new b(description, string, bl, string2, string3, string4, string5, string6, string7);
    }

    @Nonnull
    public String getDisplayName(@Nullable Map<String, String> settings) {
        return LoginApiAccessor.I18N.getMsg(this.name(), new Object[0]);
    }

    @Nullable
    public AuthenticationDescription getAuthenticationDescription(@Nonnull Map<String, String> settings, boolean isApplication, boolean isProxy) {
        Set<String> set;
        String string = settings.get("ldap.loginurl");
        set = string instanceof String ? (set = b.a(string)) : null;
        settings.put("icon", ((Object)((Object)this)).getClass().getResource("/com/inet/authentication/ldap/ldap.png").toString());
        settings.put("color", "#2b8631");
        if (set == null || set.size() > 0) {
            return new AuthenticationDescription((AuthenticationProvider)this, settings, this.name(), AuthenticationDescription.BasicSupport.Only);
        }
        return null;
    }

    @Nonnull
    public Map<String, String> applySettings(@Nonnull Map<String, String> clientProperties, @Nonnull Configuration config, @Nonnull List<Map<String, String>> originalInConfig) {
        Object object;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = clientProperties.get("ldap.loginurl");
        if (string instanceof List) {
            object2 = new LinkedHashSet<String>();
            List list = (List)((Object)string);
            Iterator object3 = list.iterator();
            while (object3.hasNext()) {
                object = (List)object3.next();
                ((HashSet)object2).add((String)object.get(0));
            }
            String string2 = ((AbstractSet)object2).equals(b.b()) ? "" : new Json().toJson(object2);
            hashMap.put("ldap.loginurl", string2);
        } else if (string instanceof String) {
            hashMap.put("ldap.loginurl", string);
        }
        hashMap.put("ldap.trustall", clientProperties.get("ldap.trustall"));
        hashMap.put("ldap.default_domain", clientProperties.get("ldap.default_domain"));
        hashMap.put("ldap.bind_user", clientProperties.get("ldap.bind_user"));
        object2 = clientProperties.get("ldap.bind_password");
        if ("******".equals(object2)) {
            for (Map map : originalInConfig) {
                object = (String)map.get("ldap.bind_password");
                if (object == null) continue;
                hashMap.put("ldap.bind_password", (String)object);
            }
        } else if (!StringFunctions.isEmpty((String)object2)) {
            hashMap.put("ldap.bind_password", Encryption.encrypt((String)object2));
        }
        hashMap.put("ldap.base_dn", clientProperties.get("ldap.base_dn"));
        hashMap.put("ldap.user_rdn", clientProperties.get("ldap.user_rdn"));
        hashMap.put("ldap.group_rdn", clientProperties.get("ldap.group_rdn"));
        return hashMap;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Only a password mask")
    public void transformGuiProperties(@Nonnull Map<String, Object> properties) {
        Object object = properties.get("ldap.loginurl");
        if (object == null || object.getClass() == String.class) {
            properties.put("ldap.loginurl", com.inet.authentication.ldap.structure.a.e((String)object));
        }
        if (properties.get("ui") == null) {
            if (!StringFunctions.isEmpty((String)((String)properties.get("ldap.bind_password")))) {
                properties.put("ldap.bind_password", "******");
            }
            properties.put("ui", "true");
        }
    }
}

