/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.duopush;

import com.inet.authentication.LoginProcessor;
import com.inet.authentication.twofactor.api.TwoFactorProvider;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class a
implements TwoFactorProvider {
    private static final ConfigValue<String> c = new ConfigValue(com.inet.authentication.duopush.structure.a.g);
    private static final ConfigValue<String> d = new ConfigValue(com.inet.authentication.duopush.structure.a.h);
    private static final ConfigValue<String> e = new ConfigValue(com.inet.authentication.duopush.structure.a.f);
    private static final I18nMessages MSG = new I18nMessages("com.inet.authentication.duopush.structure.i18n.ConfigStructure", a.class);

    @Nonnull
    public String getExtensionName() {
        return "duopush";
    }

    public String getDisplayName() {
        return "Duo Push";
    }

    public boolean available(@Nonnull UserAccount user) {
        return !StringFunctions.isEmpty((String)((String)c.get())) && !StringFunctions.isEmpty((String)((String)d.get())) && !StringFunctions.isEmpty((String)((String)e.get()));
    }

    @Nullable
    public String createData(GUID accountID) {
        try {
            Map<String, Object> map = a.a("POST", "/auth/v2/enroll", Map.of("valid_secs", String.valueOf(900), "factor", "push", "device", "auto"));
            Map map2 = (Map)map.get("response");
            SessionStore.getHttpSession().setAttribute("duopush.enroll", (Object)map2);
            return (String)map2.get("user_id");
        }
        catch (ClientMessageException clientMessageException) {
            throw clientMessageException;
        }
        catch (Throwable throwable) {
            LoginProcessor.LOGGER.debug((Object)throwable);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
        }
    }

    public String showCurrentSettings(@Nonnull UserAccount user, String user_id, boolean isNew) {
        try {
            if (isNew) {
                String string;
                Map map = (Map)SessionStore.getHttpSession().getAttribute("duopush.enroll");
                String string2 = (String)map.get("activation_barcode");
                String string3 = (String)map.get("activation_code");
                if (string3.startsWith("duo://")) {
                    string = string3;
                    string3 = string3.substring(6);
                } else {
                    string = (String)map.get("activation_url");
                }
                String string4 = StringFunctions.encodeHTML((String)MSG.getMsg("duopush.enroll.instructions1", new Object[0]));
                String string5 = StringFunctions.encodeHTML((String)MSG.getMsg("duopush.enroll.instructions2", new Object[0]));
                String string6 = StringFunctions.encodeHTML((String)MSG.getMsg("duopush.enroll.instructions3", new Object[0]));
                String string7 = StringFunctions.encodeHTML((String)MSG.getMsg("duopush.enroll.instructions4", new Object[0]));
                StringBuilder stringBuilder = new StringBuilder("<center><strong><br>");
                stringBuilder.append(string4);
                stringBuilder.append("</strong><br><br><img src='");
                stringBuilder.append(string2);
                stringBuilder.append("'><br><br>");
                stringBuilder.append(string5).append("<br><input type=\"text\" readonly style='width:100%;' value='");
                stringBuilder.append(string3).append("'><br><br>");
                stringBuilder.append(string6).append("<br>");
                stringBuilder.append("<a href='").append(string).append("'>");
                stringBuilder.append(string7).append("</a>");
                stringBuilder.append("</center>");
                return stringBuilder.toString();
            }
            String string = (String)SessionStore.getHttpSession().getAttribute("duopush.responsecode");
            if (string != null) {
                String[] stringArray = string.split("#");
                long l = Long.parseLong(stringArray[1]);
                string = l + 120000L < System.currentTimeMillis() ? null : stringArray[0];
            }
            if (string == null || SessionStore.getHttpSession().getAttribute("duopush.txid") == null) {
                string = this.a(user_id);
                SessionStore.getHttpSession().setAttribute("duopush.responsecode", (Object)(string + "#" + System.currentTimeMillis()));
            }
            return string;
        }
        catch (Throwable throwable) {
            LoginProcessor.LOGGER.debug((Object)throwable);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
        }
    }

    private String a(@Nonnull String string) throws Exception {
        Object object;
        Map<String, Object> map;
        Map<String, Object> map2 = a.a("POST", "/auth/v2/preauth", Map.of("user_id", string, "client_supports_verified_push", "1"));
        Map map3 = (Map)map2.get("response");
        String string2 = (String)map3.get("result");
        if (string2 != null) {
            switch (string2) {
                case "allow": 
                case "bypass": {
                    SessionStore.getHttpSession().removeAttribute("duopush.txid");
                    return "<center><strong><br>2FA nicht erforderlich (Bypass/Allow)</strong></center>";
                }
                default: {
                    String string3 = (String)map3.get("status_msg");
                    throw new ClientMessageException(string3);
                }
                case "auth": 
            }
        }
        String string4 = (String)map3.get("verification_code");
        String string5 = (String)map3.get("txid");
        if (string5 == null) {
            map = a.a("POST", "/auth/v2/auth", Map.of("user_id", string, "factor", "push", "device", "auto", "async", "1"));
            object = (Map)map.get("response");
            string5 = (String)object.get("txid");
            if (string5 == null) {
                throw new ClientMessageException("Duo auth: keine txid erhalten");
            }
        } else {
            a.a("POST", "/auth/v2/auth", Map.of("user_id", string, "txid", string5, "factor", "push", "device", "auto", "async", "1"));
        }
        SessionStore.getHttpSession().setAttribute("duopush.txid", (Object)string5);
        map = StringFunctions.encodeHTML((String)MSG.getMsg("duopush.auth.instructions1", new Object[0]));
        object = "<center><h3>" + (String)((Object)map) + "</h3>";
        if (string4 != null) {
            object = (String)object + "<h1>" + string4 + "</h1>";
        }
        object = (String)object + "</center>";
        return object;
    }

    public boolean validateTwoFactorCode(String code, String user_id) {
        try {
            String string = (String)SessionStore.getHttpSession().getAttribute("duopush.txid");
            if (string == null) {
                Map map = (Map)SessionStore.getHttpSession().getAttribute("duopush.enroll");
                String string2 = (String)map.get("activation_code");
                Map<String, Object> map2 = a.a("POST", "/auth/v2/enroll_status", Map.of("user_id", user_id, "activation_code", string2));
                String string3 = (String)map2.get("response");
                if (string3 != null) {
                    switch (string3) {
                        case "success": {
                            return true;
                        }
                        case "waiting": {
                            return false;
                        }
                    }
                }
            } else {
                Map<String, Object> map = a.a("GET", "/auth/v2/auth_status", Map.of("txid", string));
                Map map3 = (Map)map.get("response");
                String string4 = (String)map3.get("result");
                if (string4 != null) {
                    switch (string4) {
                        case "allow": 
                        case "bypass": {
                            return true;
                        }
                        case "waiting": {
                            return false;
                        }
                    }
                    String string5 = (String)map3.get("status_msg");
                    if (string5 != null) {
                        throw new ClientMessageException(string5);
                    }
                }
            }
        }
        catch (ClientMessageException clientMessageException) {
            throw clientMessageException;
        }
        catch (Throwable throwable) {
            LoginProcessor.LOGGER.debug((Object)throwable);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
        }
        throw new ClientMessageException("Duo authentication failed");
    }

    private static Map<String, Object> a(@Nonnull String string, @Nonnull String string2, @Nullable Map<@Nonnull String, @Nonnull String> map) throws Exception {
        return a.a(string, string2, map, (String)c.get(), (String)d.get(), (String)e.get());
    }

    @Nonnull
    public static Map<String, Object> a(@Nonnull String string, @Nonnull String string2, @Nullable Map<@Nonnull String, @Nonnull String> map, String string3, String string4, String string5) throws Exception {
        HttpURLConnection httpURLConnection = a.b(string, string2, map, string3, string4, string5);
        try {
            HashMap hashMap = (HashMap)new Json().fromJson(httpURLConnection.getInputStream(), HashMap.class);
            if ("FAIL".equals(hashMap.get("stat"))) {
                throw new ClientMessageException((String)hashMap.get("message"));
            }
            return hashMap;
        }
        catch (IOException iOException) {
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((URLConnection)httpURLConnection));
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only settings from administrator is used")
    private static HttpURLConnection b(@Nonnull String string2, @Nonnull String string3, @Nullable Map<@Nonnull String, @Nonnull String> map, String string4, String string5, String string6) throws Exception {
        String string7;
        String string8 = "https://" + string6 + string3;
        String string9 = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now());
        if (map != null) {
            string7 = map.keySet().stream().sorted().map(string -> a.b(string) + "=" + a.b((String)map.get(string))).collect(Collectors.joining("&"));
            if (!"POST".equals(string2)) {
                string8 = string8 + "?" + string7;
            }
        } else {
            string7 = "";
        }
        String string10 = string9 + "\n" + string2 + "\n" + string6.toLowerCase() + "\n" + string3 + "\n" + string7;
        Mac mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec secretKeySpec = new SecretKeySpec(string5.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
        mac.init(secretKeySpec);
        byte[] byArray = mac.doFinal(string10.getBytes(StandardCharsets.UTF_8));
        String string11 = string4 + ":" + EncodingFunctions.toHexString((byte[])byArray, (int)byArray.length);
        String string12 = "Basic " + Base64.getEncoder().encodeToString(string11.getBytes(StandardCharsets.UTF_8));
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string8).openConnection();
        httpURLConnection.setRequestMethod(string2);
        httpURLConnection.addRequestProperty("Date", string9);
        httpURLConnection.addRequestProperty("Authorization", string12);
        if ("POST".equals(string2)) {
            httpURLConnection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setDoOutput(true);
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                outputStream.write(string7.getBytes(StandardCharsets.UTF_8));
            }
        }
        return httpURLConnection;
    }

    @Nonnull
    private static String b(@Nonnull String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }
}

