/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import java.util.Arrays;
import java.util.stream.IntStream;

public class AttachmentPreviewEntryDistributionBalancer {
    private final int entryLimit;

    public AttachmentPreviewEntryDistributionBalancer(int entryLimit) {
        this.entryLimit = Math.max(entryLimit, 0);
    }

    public int[] balance(int[] attCounts) {
        int entriesToProcess;
        attCounts = Arrays.copyOf(attCounts, attCounts.length);
        for (int index = 0; index < attCounts.length; ++index) {
            attCounts[index] = Math.max(attCounts[index], 0);
        }
        int[] result = new int[attCounts.length];
        int processedEntriesCount = 0;
        block1: while (!this.isLimitReached(processedEntriesCount) && (entriesToProcess = IntStream.of(attCounts).sum()) != 0) {
            for (int index = 0; index < attCounts.length; ++index) {
                int count = attCounts[index];
                if (count > 0) {
                    int n = index;
                    attCounts[n] = attCounts[n] - 1;
                    int n2 = index;
                    result[n2] = result[n2] + 1;
                    ++processedEntriesCount;
                }
                if (this.isLimitReached(processedEntriesCount)) continue block1;
            }
        }
        return result;
    }

    private boolean isLimitReached(int processedEntriesCount) {
        return processedEntriesCount == this.entryLimit;
    }
}

