/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.plugins.attachments.server.DirectoryTreeManager;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.PersistenceEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AttachmentFileService {
    private DirectoryTreeManager attDirManager;

    public AttachmentFileService(DirectoryTreeManager attDirManager) throws IllegalArgumentException {
        if (attDirManager == null) {
            throw new IllegalArgumentException("attachment directory manager must not be null");
        }
        this.attDirManager = attDirManager;
    }

    public PersistenceEntry createAttachmentFile(InputStream sourceStream, String fileName) throws IOException, IllegalArgumentException {
        if (sourceStream == null) {
            throw new IllegalArgumentException("source stream must not be null");
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("file name must not be null, contain only whitespaces or be empty");
        }
        PersistenceEntry directory = this.attDirManager.getDirectoryWhichIsNotFull();
        List<String> existingFileNames = directory.getChildren().stream().map(PersistenceEntry::getName).collect(Collectors.toList());
        String uniqueFileName = AttachmentFilePathBuilder.getUniqueFileName(fileName, existingFileNames);
        PersistenceEntry targetFile = directory.resolve(uniqueFileName);
        try (OutputStream out = targetFile.getOutputStream();){
            IOFunctions.copyData((InputStream)sourceStream, (OutputStream)out);
        }
        sourceStream.close();
        return targetFile;
    }

    public void deleteFile(String filePathRelativeToAttDir) throws IllegalArgumentException {
        this.getAttachmentFile(filePathRelativeToAttDir).deleteValue();
    }

    public PersistenceEntry getAttachmentFile(String filePathRelativeToAttDir) throws IllegalArgumentException {
        this.throwExceptionIfNullOrInvalid(filePathRelativeToAttDir);
        return AppDataLocation.getAttachmentFile((String)filePathRelativeToAttDir);
    }

    public static String getParentDirPathWhichIsRelativeToAttachmentDir(PersistenceEntry file) throws IllegalArgumentException {
        String attachmentDirPath;
        if (file == null) {
            throw new IllegalArgumentException("given file must not be null");
        }
        String filePath = file.getPath();
        if (!filePath.startsWith(attachmentDirPath = AppDataLocation.getAttachmentDirectory().getPath())) {
            throw new IllegalArgumentException("given file's path must start with attachment directory path\nattachment dir path=\"" + attachmentDirPath + "\"\ngiven file's path=\"" + filePath + "\"");
        }
        if (attachmentDirPath.equals(filePath)) {
            throw new IllegalArgumentException("given file's path must not denote attachment directory");
        }
        ArrayList<String> elements = new ArrayList<String>();
        PersistenceEntry current = file;
        while (!(current = current.getParent()).getPath().equals(attachmentDirPath)) {
            elements.add(0, current.getName());
        }
        StringBuilder builder = new StringBuilder();
        for (String elem : elements) {
            builder.append('/').append(elem);
        }
        if (!elements.isEmpty()) {
            builder.append('/');
        }
        return builder.toString();
    }

    private void throwExceptionIfNullOrInvalid(String path) throws IllegalArgumentException {
        String msg = null;
        if (path == null) {
            msg = "given path must not be null";
        } else if (!path.trim().startsWith("/")) {
            msg = "given path must start with / character";
        } else if (path.trim().length() <= 1) {
            msg = "given path must not be empty or /";
        }
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean exists(String filePathRelativeToAttDir) {
        return this.getAttachmentFile(filePathRelativeToAttDir).exists();
    }
}

