/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.extension.UpdateReaStepTextExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddOrDeleteAttachmentActionExtensionFactory;
import com.inet.helpdesk.plugins.attachments.server.extensions.TicketAttachmentAdder;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.shared.http.upload.AttachmentType;
import java.util.Collections;
import java.util.List;

public class UpdateReaStepTextExtensionWithAttachmentsFactory
implements TicketActionExtensionFactory {
    private TicketAttachmentAdder adder = new TicketAttachmentAdder();

    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        AddAttachmentsExtensionData extData = (AddAttachmentsExtensionData)arguments.get(AttachmentsServerPlugin.EXTARG_ATTACHMENTS);
        if (action.getId() == -22) {
            return new UpdateReaStepTextExtensionWithAttachments(arguments, extData == null ? Collections.emptyList() : extData.getAttachments());
        }
        return null;
    }

    public class UpdateReaStepTextExtensionWithAttachments
    extends UpdateReaStepTextExtensionFactory.UpdateReaStepTextExtension {
        private final List<LargeContent> attachments;

        public UpdateReaStepTextExtensionWithAttachments(ExtensionArguments arguments, List<LargeContent> attachments) {
            super(arguments);
            this.attachments = attachments;
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            String updatedStepContent;
            super.extendTicketAction(action, ticket, reaStep, operations);
            OperationChangedReaStep changedStep = (OperationChangedReaStep)ticket.getChangedReaSteps().get(ticket.getChangedReaSteps().size() - 1);
            int ticketID = ((TicketVO)ticket.getOldTicket().get()).getID();
            boolean addedNonEmbeddedAtts = false;
            if (!this.attachments.isEmpty()) {
                String resultingStepContent = UpdateReaStepTextExtensionWithAttachmentsFactory.this.adder.addAttachmentsToTicket(ticketID, this.stepId, changedStep.getText().getText(), this.attachments);
                if (resultingStepContent != null) {
                    changedStep.getText().setText(resultingStepContent);
                }
                if (this.attachments.stream().anyMatch(lc -> lc.getContentType() == AttachmentType.Attachment)) {
                    addedNonEmbeddedAtts = true;
                }
            }
            if (!this.newText.getText().isEmpty() && this.newText.hasHtmlContent() && (updatedStepContent = UpdateReaStepTextExtensionWithAttachmentsFactory.this.adder.convertExternalImagesToAttachments(ticketID, this.stepId, this.newText.getText())) != null) {
                this.newText.setText(updatedStepContent);
            }
            if (addedNonEmbeddedAtts) {
                AddOrDeleteAttachmentActionExtensionFactory.updateAttachmentFlagForBundle(true, ticket);
            }
        }
    }
}

