/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.extensions;

import com.inet.helpdesk.core.mail.extension.SendMailExtension;
import com.inet.helpdesk.core.mail.extension.SendMailExtensionContext;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.TicketAttachmentService;
import com.inet.helpdesk.plugins.attachments.server.mail.ImageReferenceReplacer;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.BooleanMatcher;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.mail.api.BaseEmail;
import java.sql.SQLException;
import java.util.List;

public class AttachmentSendMailExtension
implements SendMailExtension {
    private TicketAttachmentService ticketService;
    private AttachmentService attachmentService;

    public AttachmentSendMailExtension(TicketAttachmentService ticketService, AttachmentService attachmentService) {
        this.ticketService = ticketService;
        this.attachmentService = attachmentService;
    }

    public void doExtendMailMessage(SendMailExtensionContext context, int ticketId, int reaStepId) {
        this.addNonEmbeddedAttachments(context, ticketId, reaStepId);
        this.addEmbeddedImagesAsAttachments(context);
    }

    private void addEmbeddedImagesAsAttachments(SendMailExtensionContext context) {
        if (!context.getReaStepText().hasHtmlContent()) {
            return;
        }
        String content = context.getMailContextText();
        content = ImageReferenceReplacer.genericReplaceImageSources(content, src -> {
            if (!src.startsWith("Attachments/")) {
                return src;
            }
            String restfulPath = src;
            restfulPath = EncodingFunctions.decodeUrlPath((String)restfulPath);
            restfulPath = StringFunctions.decodeHTML((String)restfulPath);
            AttachmentKey attachmentKey = AttachmentFilePathBuilder.convertRestfulPathToKey(restfulPath);
            try {
                AttachmentRow row = this.attachmentService.getAttachment(attachmentKey);
                if (row == null) {
                    AttachmentsServerPlugin.LOGGER.warn((Object)("Cannot find attachment for: " + src));
                    return src;
                }
                AttachmentFileRow fileRow = this.attachmentService.getAttachmentFile(row.getChecksum(), row.getFileLength());
                String fileName = this.getUniqueFilename(row.getFileName(), context.getAttachmentsForMail());
                context.getAttachmentsForMail().add(new SendMailExtension.AttachmentInfo(fileName, fileRow.getFilePath()));
                return "cid:" + BaseEmail.encodeMIMEText((String)fileName);
            }
            catch (SQLException e) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)e);
                return src;
            }
        });
        context.setMailContextText(content);
    }

    private void addNonEmbeddedAttachments(SendMailExtensionContext context, int ticketId, int reaStepId) {
        List<AttachmentDescription> nonEmbeddedAttachments = this.ticketService.getAttachmentsForTicket(ticketId, ContextType.supporter).getAttachments().getMatched(BooleanMatcher.ANY, BooleanMatcher.ONLY_FALSE);
        nonEmbeddedAttachments.stream().filter(att -> att.getStepId() == reaStepId).forEach(att -> {
            try {
                AttachmentRow row = this.attachmentService.getAttachment(new AttachmentKey(att.getAttachmentType(), att.getOwnerId(), att.getStepId(), -1, att.getFileName()));
                AttachmentFileRow fileRow = this.attachmentService.getAttachmentFile(row.getChecksum(), row.getFileLength());
                context.getAttachmentsForMail().add(new SendMailExtension.AttachmentInfo(att.getFileName(), fileRow.getFilePath()));
            }
            catch (IllegalArgumentException | SQLException e) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)e);
            }
        });
    }

    private String getUniqueFilename(String fileName, List<SendMailExtension.AttachmentInfo> attachmentsForMail) {
        while (this.existsAlready((String)fileName, attachmentsForMail)) {
            fileName = "_" + (String)fileName;
        }
        return fileName;
    }

    private boolean existsAlready(String fileName, List<SendMailExtension.AttachmentInfo> attachmentsForMail) {
        return attachmentsForMail.stream().anyMatch(att -> att.getFileName().equals(fileName));
    }
}

