/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.persistence.PersistenceEntry;
import java.util.HashSet;
import java.util.List;

public class AttachmentFileChecker {
    private HashSet<String> managedAttFileRelativePaths = new HashSet();

    public AttachmentFileChecker(List<AttachmentFileRow> attachmentFiles) {
        ValidationUtils.throwExceptionIfNull(attachmentFiles, "attachmentFiles");
        ValidationUtils.throwExceptionIfListContainsNull(attachmentFiles, "attachmentFiles");
        for (AttachmentFileRow attFile : attachmentFiles) {
            String attFileRelativePath = attFile.getFilePath().substring(1);
            this.managedAttFileRelativePaths.add(attFileRelativePath);
        }
    }

    public boolean isManagedAttachmentFile(PersistenceEntry attachmentDirectory, PersistenceEntry file) {
        ValidationUtils.throwExceptionIfNull(attachmentDirectory, "attachmentDirectory");
        ValidationUtils.throwExceptionIfNull(file, "file");
        String attDirPath = attachmentDirectory.getPath();
        String filePath = file.getPath();
        if (!filePath.startsWith(attDirPath) || filePath.equals(attDirPath)) {
            return false;
        }
        String relativePath = filePath.substring(attDirPath.length() + 1);
        return this.managedAttFileRelativePaths.contains(relativePath);
    }
}

