/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.helpdesk.shared.rpc.LargeContent;
import java.util.List;

public class PreConditionCheckerForAttachmentServices {
    public void checkPreConditionsOfAddAttachmentsMethod(int ownerId, int stepId, LargeContent[] attachments) {
        ValidationUtils.throwExceptionIfNegative(ownerId, "ownerId");
        if (attachments == null || attachments.length == 0) {
            throw new IllegalArgumentException("attachments array must not be null or empty");
        }
        for (LargeContent att : attachments) {
            String attName = att.getName();
            if (attName != null && !attName.trim().isEmpty()) continue;
            throw new IllegalArgumentException("at least one attachment file name is null or empty after trim");
        }
    }

    public void checkPreConditionsOfDeleteAttachmentsMethod(AttachmentOwnerType expectedType, List<AttachmentDescription> toDelete) {
        ValidationUtils.throwExceptionIfNull(toDelete, "list of attachment descriptions");
        for (AttachmentDescription description : toDelete) {
            Integer ownerId = description.getOwnerId();
            Integer stepId = description.getStepId();
            String fileName = description.getFileName();
            String additionalInfo = " (from description where fileName =\"" + fileName + "\" ownerId=\"" + ownerId + "\" stepId=\"" + stepId + "\")";
            ValidationUtils.throwExceptionIfNullOrNegative(ownerId, "ticketId" + additionalInfo);
            ValidationUtils.throwExceptionIfNull(stepId, "stepId" + additionalInfo);
            ValidationUtils.throwExceptionIfNullOrEmptyAfterTrim(fileName, "fileName" + additionalInfo);
            if (description.getAttachmentType().equals(expectedType)) continue;
            throw new IllegalArgumentException("AttachmentType must be " + expectedType.toString() + additionalInfo);
        }
    }
}

