/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;

@JsonData
public class AttachmentKey {
    private Integer ownerId;
    private Integer stepId;
    private Integer additionalId;
    private AttachmentOwnerType type;
    private String fileName;

    public AttachmentKey(AttachmentOwnerType type, Integer ownerId, Integer stepId, Integer additionalId, String fileName) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (ownerId == null || ownerId < 0) {
            throw new IllegalArgumentException("ownerId must not be null or negative");
        }
        if (stepId == null) {
            throw new IllegalArgumentException("stepId must not be null");
        }
        if (additionalId == null) {
            throw new IllegalArgumentException("additionalId must not be null");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName must not be null or empty");
        }
        this.type = type;
        this.ownerId = ownerId;
        this.stepId = stepId;
        this.additionalId = additionalId;
        this.fileName = fileName;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public Integer getStepId() {
        return this.stepId;
    }

    public Integer getAdditionalId() {
        return this.additionalId;
    }

    public AttachmentOwnerType getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return "AttachmentKey [ownerId=" + this.ownerId + ", stepId=" + this.stepId + ", additionalId=" + this.additionalId + ", type=" + String.valueOf(this.type) + ", fileName=" + this.fileName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalId == null ? 0 : this.additionalId.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = 31 * result + (this.stepId == null ? 0 : this.stepId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentKey other = (AttachmentKey)obj;
        if (this.additionalId == null ? other.additionalId != null : !this.additionalId.equals(other.additionalId)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.ownerId == null ? other.ownerId != null : !this.ownerId.equals(other.ownerId)) {
            return false;
        }
        if (this.stepId == null ? other.stepId != null : !this.stepId.equals(other.stepId)) {
            return false;
        }
        return this.type == other.type;
    }
}

