/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared;

import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;

public class AttachmentPathPatcher {
    public static final String OLD_STYLE_PATH_PREFIX = "/Attachments_";
    private static final String TEMP_PATH_PREFIX = "/Attachments/Attachments_Temp/";
    public static final String ATTACHMENT_CONTEXT_PREFIX = "/Attachments/";

    public static String patch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("given path must not be null");
        }
        if (AttachmentPathPatcher.doesStartWithTempPath(path)) {
            return path;
        }
        if (AttachmentPathPatcher.doesStartWithOldStyle(path)) {
            return AttachmentPathPatcher.convertToRestfulIfPossible(path);
        }
        if (AttachmentPathPatcher.doesStartWithRestfulStyle(path)) {
            return AttachmentPathPatcher.includeTicketAttachmentTypeIfNoneIsSet(path);
        }
        return path;
    }

    private static boolean doesStartWithTempPath(String path) {
        return path.startsWith(TEMP_PATH_PREFIX);
    }

    private static boolean doesStartWithOldStyle(String path) {
        return path.startsWith(OLD_STYLE_PATH_PREFIX);
    }

    private static String convertToRestfulIfPossible(String path) {
        String newPath = path.substring(OLD_STYLE_PATH_PREFIX.length());
        int indexOf = newPath.indexOf(47);
        if (indexOf >= 0) {
            newPath = newPath.substring(indexOf + 1);
            try {
                AttachmentKey attachmentKey = AttachmentFilePathBuilder.convertOldPathToKey(newPath, AttachmentOwnerType.TicketAttachment);
                return "/" + AttachmentFilePathBuilder.getRestfulPath(attachmentKey);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return path;
    }

    private static String includeTicketAttachmentTypeIfNoneIsSet(String path) {
        if (AttachmentPathPatcher.doesIncludeAttachmentType(path)) {
            return path;
        }
        return AttachmentPathPatcher.includeTicketAttachmentType(path);
    }

    private static String includeTicketAttachmentType(String path) {
        String ticketAttachmentSubContext = AttachmentOwnerType.TicketAttachment.getAttachmentSubContext();
        String attachmentPart = path.substring(ATTACHMENT_CONTEXT_PREFIX.length() - 1);
        return ATTACHMENT_CONTEXT_PREFIX + ticketAttachmentSubContext + attachmentPart;
    }

    private static boolean doesIncludeAttachmentType(String path) {
        for (AttachmentOwnerType type : AttachmentOwnerType.values()) {
            if (!path.startsWith(ATTACHMENT_CONTEXT_PREFIX + type.getAttachmentSubContext() + "/")) continue;
            return true;
        }
        return false;
    }

    private static boolean doesStartWithRestfulStyle(String path) {
        return path.startsWith(ATTACHMENT_CONTEXT_PREFIX);
    }
}

