/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.authentication.AccessForbiddenException;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.quickticket.api.LoadQuickTicketUtil;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonData
@InternalApi
public abstract class AttachmentOwnerType {
    private static final Map<Integer, AttachmentOwnerType> types = new HashMap<Integer, AttachmentOwnerType>();
    private static final boolean HAVE_QUICKTICKET_PLUGIN = ServerPluginManager.getInstance().isPluginLoaded("quickticket");
    private static final boolean HAVE_INVENTORY_PLUGIN = ServerPluginManager.getInstance().isPluginLoaded("inventory");
    public static AttachmentOwnerType TicketAttachment = new AttachmentOwnerType(1, "ticket"){

        @Override
        public void checkPermission(UserAccount userAccount, AttachmentKey key) throws AccessForbiddenException {
            TicketPermissionChecker permissionChecker = TicketManager.getTicketPermissionChecker();
            if (!permissionChecker.checkCurrentUserCanReadTicket(key.getOwnerId().intValue())) {
                throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.ticket.read", new Object[]{key.getOwnerId()}));
            }
            if (key.getStepId() != null && key.getStepId() != -1 && !permissionChecker.checkCurrentUserCanReadReaStep(key.getStepId().intValue())) {
                throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.reastep.read", new Object[]{key.getStepId()}));
            }
        }
    };
    public static AttachmentOwnerType DeviceAttachment = new AttachmentOwnerType(2, "device"){

        @Override
        public void checkPermission(UserAccount userAccount, AttachmentKey key) throws AccessForbiddenException {
            String inactiveMsg = AttachmentsServerPlugin.MSG.getMsg("error.permission.inventory.inactive", new Object[0]);
            if (!HAVE_INVENTORY_PLUGIN) {
                throw new AccessForbiddenException(inactiveMsg);
            }
            if (userAccount == null) {
                throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.device.access", new Object[]{key.getOwnerId()}));
            }
            if (!SystemPermissionChecker.checkAccess((Permission)Permission.valueOf((String)"inventoryRead"))) {
                throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.inventory.access", new Object[0]));
            }
            if (!SystemPermissionChecker.checkAccess((Permission)Permission.valueOf((String)"inventoryAll"))) {
                AssetManager manager = AssetManager.getInstance();
                IndexSearchEngine assetSearch = manager.getSearchEngine();
                Integer assetIntId = key.getOwnerId();
                Object[] results = assetSearch.simpleSearch(new SearchCommand(AssetFields.FIELD_INT_ID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)("" + assetIntId))).toArray();
                if (results.length == 0) {
                    throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.asset.unknown", new Object[]{assetIntId}));
                }
                GUID asset = (GUID)results[0];
                GUID currentUserId = userAccount.getID();
                try {
                    AssetView assetView = manager.getAsset(asset);
                    if (assetView == null) {
                        throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.asset.notexists", new Object[]{assetIntId}));
                    }
                }
                catch (AccessDeniedException e) {
                    if (e instanceof AccessForbiddenException) {
                        throw e;
                    }
                    throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.device.access", new Object[]{key.getOwnerId()}));
                }
            }
        }
    };
    public static AttachmentOwnerType AutoTextAttachment = new AttachmentOwnerType(4, "autoText"){

        @Override
        public void checkPermission(UserAccount userAccount, AttachmentKey key) throws AccessForbiddenException {
            AutoTextManager autoTextManager = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
            AutoTextVO autoTextVO = (AutoTextVO)autoTextManager.get(key.getOwnerId().intValue());
            if (autoTextVO == null) {
                throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.autotext.unknown", new Object[]{key.getOwnerId()}));
            }
            List availableAutoTextsForUser = autoTextManager.getAvailableAutoTextsForUser(UserManager.getInstance().getCurrentUserAccountID());
            if (!availableAutoTextsForUser.stream().anyMatch(v -> Objects.equals(v.getId(), autoTextVO.getId()))) {
                throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.autotext.read", new Object[]{key.getOwnerId()}));
            }
        }
    };
    public static AttachmentOwnerType Temp = new AttachmentOwnerType(5, "temp"){

        @Override
        public void checkPermission(UserAccount userAccount, AttachmentKey key) throws AccessForbiddenException {
        }
    };
    public static AttachmentOwnerType QuickTicketAttachment = new AttachmentOwnerType(6, "quickTicket"){

        @Override
        public void checkPermission(UserAccount userAccount, AttachmentKey key) throws AccessForbiddenException {
            block24: {
                String inactiveMsg = AttachmentsServerPlugin.MSG.getMsg("error.permission.quickticket.inactive", new Object[0]);
                if (!HAVE_QUICKTICKET_PLUGIN) {
                    throw new AccessForbiddenException(inactiveMsg);
                }
                String sql = "SELECT QuickTicketUUID FROM tblQuickTickets WHERE QuickTicketID = ?";
                try (Connection c = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
                     PreparedStatement stm = c.prepareStatement(sql);){
                    stm.setInt(1, key.getOwnerId());
                    try (ResultSet rs = stm.executeQuery();){
                        if (rs.next()) {
                            String guid = rs.getString(1);
                            if (guid != null && !guid.isBlank()) {
                                if (!LoadQuickTicketUtil.checkFolderPermissionsForQuickTicket((GUID)GUID.valueOf((String)guid))) {
                                    throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.quickticket.read", new Object[]{key.getOwnerId()}));
                                }
                                break block24;
                            }
                            throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.quickticket.unknown", new Object[]{key.getOwnerId()}));
                        }
                        throw new AccessForbiddenException(AttachmentsServerPlugin.MSG.getMsg("error.permission.quickticket.notfound", new Object[]{key.getOwnerId()}));
                    }
                }
                catch (SQLException ex) {
                    throw new IllegalStateException(ex.getMessage(), ex);
                }
            }
        }
    };
    private int id;
    private String attachmentSubContext;

    private AttachmentOwnerType() {
    }

    public AttachmentOwnerType(int id, String attachmentSubContext) {
        this.id = id;
        this.attachmentSubContext = attachmentSubContext;
        types.put(id, this);
    }

    public int getId() {
        return this.id;
    }

    public String getAttachmentSubContext() {
        return this.attachmentSubContext;
    }

    public String getDisplayName() {
        return null;
    }

    public static AttachmentOwnerType getTypeForId(int id) {
        AttachmentOwnerType type = types.get(id);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("There is no type for given id=" + id);
    }

    public static Collection<AttachmentOwnerType> values() {
        return types.values();
    }

    public static AttachmentOwnerType getTypeForSubContext(String attachmentSubContext) {
        for (AttachmentOwnerType type : AttachmentOwnerType.values()) {
            if (!type.getAttachmentSubContext().equals(attachmentSubContext)) continue;
            return type;
        }
        throw new IllegalArgumentException("There is no type for given attachmentSubContext=" + attachmentSubContext);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachmentSubContext == null ? 0 : this.attachmentSubContext.hashCode());
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentOwnerType other = (AttachmentOwnerType)obj;
        if (this.attachmentSubContext == null ? other.attachmentSubContext != null : !this.attachmentSubContext.equals(other.attachmentSubContext)) {
            return false;
        }
        return this.id == other.id;
    }

    public String toString() {
        return "AttachmentType [id=" + this.id + ", attachmentSubContext=" + this.attachmentSubContext + "]";
    }

    public abstract void checkPermission(UserAccount var1, AttachmentKey var2) throws AccessForbiddenException;
}

