/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCare;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentPreviewEntry;
import com.inet.helpdesk.plugins.attachments.server.datacare.FoundUnrelatedAttachments;
import com.inet.helpdesk.plugins.attachments.server.datacare.UnrelatedAttachmentData;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AttachmentDataCareTask
implements DataCareTask {
    @Nonnull
    public String getExtensionName() {
        return "datacare.attachment";
    }

    public String getTitle() {
        return AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.title", new Object[0]);
    }

    public String getDescription() {
        return AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.description", new Object[0]);
    }

    public int getPriority() {
        return 300;
    }

    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        AttachmentDataCare attachmentDataCare = (AttachmentDataCare)ServerPluginManager.getInstance().getSingleInstance(AttachmentDataCare.class);
        FoundUnrelatedAttachments unrelatedAttachments = attachmentDataCare.findUnrelatedAttachments();
        ArrayList<AttachmentPreviewEntry> list = new ArrayList<AttachmentPreviewEntry>();
        for (UnrelatedAttachmentData att : unrelatedAttachments.getExemplaryAttachments()) {
            list.add(new AttachmentPreviewEntry().from(att));
        }
        DataCarePreview preview = new DataCarePreview();
        int entriesCount = unrelatedAttachments.getFoundAttachmentFilesCount() + unrelatedAttachments.getFoundAttachmentsCount();
        preview.setPreviewMsg(AttachmentsServerPlugin.MSG.getMsg(entriesCount > 0 ? "datacare.attachment.preview" : "datacare.attachment.nopreview", new Object[]{entriesCount}));
        preview.setExamples(list);
        return preview;
    }

    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        AttachmentDataCare attachmentDataCare = (AttachmentDataCare)ServerPluginManager.getInstance().getSingleInstance(AttachmentDataCare.class);
        attachmentDataCare.deleteUnrelatedAttachments();
        return null;
    }
}

