/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicatorImpl;
import com.inet.helpdesk.plugins.attachments.server.AttachmentRemover;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.helpdesk.shared.communication.CopyDeleteDevices;
import java.io.IOException;
import java.util.List;

public class CopyDeleteDeviceAttachments
implements CopyDeleteDevices {
    public static final int DEFAULT_STEP_ID = -1;
    private AttachmentDuplicatorImpl attachmentDuplicator;
    private AttachmentRemover attachmentRemover;

    public void setAttachmentDuplicator(AttachmentDuplicatorImpl attachmentDuplicator) {
        ValidationUtils.throwExceptionIfNull(attachmentDuplicator, "attachment duplicator");
        this.attachmentDuplicator = attachmentDuplicator;
    }

    public void setAttachmentRemover(AttachmentRemover attachmentRemover) {
        ValidationUtils.throwExceptionIfNull(attachmentRemover, "attachment remover");
        this.attachmentRemover = attachmentRemover;
    }

    public void afterDeleteDevice(List<Integer> removedDeviceIds) throws IOException {
        if (this.attachmentRemover == null) {
            throw new IllegalStateException("mandatory dependency attachmentRemover is not set");
        }
        ValidationUtils.throwExceptionIfNull(removedDeviceIds, "list of removed device ids");
        ValidationUtils.throwExceptionIfListIsEmpty(removedDeviceIds, "list of removed device ids");
        ValidationUtils.throwExceptionIfListContainsNull(removedDeviceIds, "list of removed device ids");
        this.attachmentRemover.removeDeviceAttachments(removedDeviceIds);
    }

    public void afterCopyDevice(int sourceDeviceID, int targetDeviceID) throws IOException {
        if (this.attachmentDuplicator == null) {
            throw new IllegalStateException("mandatory dependency attachmentDuplicator is not set");
        }
        ValidationUtils.throwExceptionIfNegative(sourceDeviceID, "sourceDeviceID");
        ValidationUtils.throwExceptionIfNegative(targetDeviceID, "targetDeviceID");
        if (sourceDeviceID == targetDeviceID) {
            throw new IllegalArgumentException("sourceDeviceID must not be equal to targetDeviceID");
        }
        this.attachmentDuplicator.duplicateAttachments(AttachmentOwnerType.DeviceAttachment, sourceDeviceID, -1, targetDeviceID, -1);
    }
}

