/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ImportedDeviceDeletionListener;
import com.inet.helpdesk.core.data.TempDirectory;
import com.inet.helpdesk.core.data.TicketDeletionMaintenanceListener;
import com.inet.helpdesk.core.mail.SendAutoMailExtension;
import com.inet.helpdesk.core.mail.extension.SendMailExtension;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.AddAttachmentsServiceMethod;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAOWithCache;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDbDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicator;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicatorImpl;
import com.inet.helpdesk.plugins.attachments.server.AttachmentFileService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentPathFilter;
import com.inet.helpdesk.plugins.attachments.server.AttachmentRecognizer;
import com.inet.helpdesk.plugins.attachments.server.AttachmentRemover;
import com.inet.helpdesk.plugins.attachments.server.AttachmentRemoverForDeletedImportedDevices;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentServlet;
import com.inet.helpdesk.plugins.attachments.server.AttachmentStatementProvider;
import com.inet.helpdesk.plugins.attachments.server.CopyDeleteDeviceAttachments;
import com.inet.helpdesk.plugins.attachments.server.DirectoryTreeManager;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdderImpl;
import com.inet.helpdesk.plugins.attachments.server.PluggableTicketSearchTagAttachmentNames;
import com.inet.helpdesk.plugins.attachments.server.PreConditionCheckerForAttachmentServices;
import com.inet.helpdesk.plugins.attachments.server.TicketAttachmentService;
import com.inet.helpdesk.plugins.attachments.server.TicketDAO;
import com.inet.helpdesk.plugins.attachments.server.TicketFieldDefinitionAttachments;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.server.backup.AttachmentsBackupTask;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCare;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareService;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareTask;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentRemoverForTicketMaintenance;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentsWithMissingFilesDataCareTask;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsForNewTicketExtensionFactory;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsTicketActionExtensionFactory;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddOrDeleteAttachmentActionExtensionFactory;
import com.inet.helpdesk.plugins.attachments.server.extensions.AttachmentSendMailExtension;
import com.inet.helpdesk.plugins.attachments.server.extensions.AutoTextAttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.server.extensions.DeleteAttachmentExtension;
import com.inet.helpdesk.plugins.attachments.server.extensions.DeviceAttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.server.extensions.TicketAttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.server.extensions.UpdateReaStepTextExtensionWithAttachmentsFactory;
import com.inet.helpdesk.plugins.attachments.server.extensions.mail.EmailAttachmentExtensionFactory;
import com.inet.helpdesk.plugins.attachments.server.mail.AutoMailAttachmentExtension;
import com.inet.helpdesk.plugins.attachments.server.protocol.AttachmentURLHandler;
import com.inet.helpdesk.plugins.attachments.server.webapi.AttachmentsWebAPIExtension;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.shared.communication.CopyDeleteDevices;
import com.inet.http.PluginServlet;
import com.inet.lib.io.URLProtocolManager;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.permissions.Permission;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import jakarta.servlet.Filter;
import java.io.File;
import java.io.IOException;
import java.net.URLStreamHandler;
import java.util.List;

@PluginInfo(id="attachments", version="25.10.259", dependencies="helpdesk;mail;htmlengine", optionalDependencies="maintenance;maintenance.helpdesk;webapi.core;fieldsettings;inventory;quickticket", packages="com.inet.helpdesk.plugins.attachments.server;com.inet.helpdesk.plugins.attachments.shared", group="tickets", flags="")
public class AttachmentsServerPlugin
implements ServerPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"Attachments");
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.attachments.server.i18n.Attachments", AttachmentsServerPlugin.class);
    public static final PluggableTicketSearchTagAttachmentNames SEARCH_TAG_ATTACHMENT_NAMES = new PluggableTicketSearchTagAttachmentNames();
    private AttachmentService attachmentService = new AttachmentService();
    private AttachmentRecognizer attachmentRecognizer = new AttachmentRecognizer();
    private PreConditionCheckerForAttachmentServices preConditionChecker = new PreConditionCheckerForAttachmentServices();
    private AddAttachmentsServiceMethod addAttachmentsServiceMethod = new AddAttachmentsServiceMethod();
    private TicketAttachmentService ticketAttachmentService = new TicketAttachmentService(this.attachmentService, this.attachmentRecognizer, this.preConditionChecker);
    private AttachmentServlet attachmentServlet = new AttachmentServlet();
    private AutoMailAttachmentExtension autoMailExtension = new AutoMailAttachmentExtension();
    private AttachmentStatementProvider attachmentStatementProvider = new AttachmentStatementProvider();
    private CopyDeleteDeviceAttachments copyDeleteDeviceAttachments = new CopyDeleteDeviceAttachments();
    private AttachmentDataCareService attachmentDataCareService = new AttachmentDataCareService();
    private AttachmentRemoverForTicketMaintenance attachmentRemoverForTicketMaintenance = new AttachmentRemoverForTicketMaintenance();
    private AttachmentRemoverForDeletedImportedDevices attachmentRemoverForDeletedImportedDevices = new AttachmentRemoverForDeletedImportedDevices();
    private AttachmentDAOWithCache attachmentDAO = new AttachmentDAOWithCache(new AttachmentDbDAO(this.attachmentStatementProvider));
    private AttachmentDuplicatorImpl attachmentDuplicator = new AttachmentDuplicatorImpl(this.attachmentDAO);
    public static final ExtensionArguments.ExtArg<AddAttachmentsExtensionData> EXTARG_ATTACHMENTS = new ExtensionArguments.ExtArg<AddAttachmentsExtensionData>(){

        public String getKey() {
            return "ticketextension.addattachments";
        }

        public Class<AddAttachmentsExtensionData> getValueType() {
            return AddAttachmentsExtensionData.class;
        }

        public String toJson(AddAttachmentsExtensionData value) {
            throw new UnsupportedOperationException();
        }

        public AddAttachmentsExtensionData fromJson(String jsonData) {
            throw new UnsupportedOperationException();
        }

        public AddAttachmentsExtensionData copyValue(AddAttachmentsExtensionData value) {
            return value.copy();
        }
    };

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("webapi", 9633, new Permission[0]){}, new String[]{"webapi.core"});
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.register(Filter.class, (Object)new AttachmentPathFilter());
        spm.register(PluginServlet.class, (Object)this.attachmentServlet);
        spm.register(TicketAttachmentProvider.class, (Object)this.ticketAttachmentService);
        spm.register(SendAutoMailExtension.class, (Object)this.autoMailExtension);
        spm.register(AttachmentService.class, (Object)this.attachmentService);
        spm.register(AttachmentStatementProvider.class, (Object)this.attachmentStatementProvider);
        spm.register(CopyDeleteDevices.class, (Object)this.copyDeleteDeviceAttachments);
        spm.register(ImportedDeviceDeletionListener.class, (Object)this.attachmentRemoverForDeletedImportedDevices);
        spm.runIfPluginLoaded("maintenance", () -> new Executable(){

            public void execute() {
                spm.register(BackupTask.class, (Object)new AttachmentsBackupTask(AttachmentsServerPlugin.this.attachmentDAO));
            }
        });
        spm.runIfPluginLoaded("maintenance.helpdesk", () -> new Executable(){

            public void execute() {
                spm.register(DataCareTask.class, (Object)new AttachmentDataCareTask());
                spm.register(DataCareTask.class, (Object)new AttachmentsWithMissingFilesDataCareTask());
                spm.register(AttachmentDataCare.class, (Object)AttachmentsServerPlugin.this.attachmentDataCareService);
                spm.register(TicketDeletionMaintenanceListener.class, (Object)AttachmentsServerPlugin.this.attachmentRemoverForTicketMaintenance);
            }
        });
        spm.register(ExtensionArguments.ExtArg.class, EXTARG_ATTACHMENTS);
        spm.register(CreateTicketExtensionFactory.class, (Object)new AddAttachmentsForNewTicketExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new AddAttachmentsTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new AddOrDeleteAttachmentActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new UpdateReaStepTextExtensionWithAttachmentsFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new DeleteAttachmentExtension());
        spm.register(PluggableTicketSearchTag.class, (Object)SEARCH_TAG_ATTACHMENT_NAMES);
        EmailAttachmentExtensionFactory emailAttFactory = new EmailAttachmentExtensionFactory();
        spm.register(CreateTicketExtensionFactory.class, (Object)emailAttFactory);
        spm.register(TicketActionExtensionFactory.class, (Object)emailAttFactory);
        spm.register(TicketFieldDefinition.class, (Object)new TicketFieldDefinitionAttachments(55));
        spm.register(SendMailExtension.class, (Object)new AttachmentSendMailExtension(this.ticketAttachmentService, this.attachmentService));
        spm.register(AttachmentDuplicator.class, (Object)this.attachmentDuplicator);
        spm.register(ExternalImageAttachmentAdder.class, (Object)new ExternalImageAttachmentAdderImpl(this.attachmentService, this.ticketAttachmentService));
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                AttachmentsWebAPIExtension.registerExtension(spm);
            }
        });
        spm.register(AttachmentDataCareExtension.class, (Object)new TicketAttachmentDataCareExtension());
        spm.register(AttachmentDataCareExtension.class, (Object)new DeviceAttachmentDataCareExtension());
        spm.register(AttachmentDataCareExtension.class, (Object)new AutoTextAttachmentDataCareExtension());
    }

    public void init(ServerPluginManager serverPluginManager) {
        ConnectionFactory connFactory = (ConnectionFactory)serverPluginManager.getSingleInstance(ConnectionFactory.class);
        this.attachmentStatementProvider.setConnectionFactory(connFactory);
        TicketDAO ticketDAO = new TicketDAO(this.attachmentStatementProvider);
        this.attachmentServlet.setAttachmentDAO(this.attachmentDAO);
        AttachmentFileService attachmentFileService = new AttachmentFileService(DirectoryTreeManager.getManager("Attachments"));
        this.attachmentService.setDependencies(this.attachmentDAO, attachmentFileService);
        this.ticketAttachmentService.setTicketDAO(ticketDAO);
        this.autoMailExtension.setDependencies(this.attachmentService, attachmentFileService);
        AttachmentRemover attachmentRemover = new AttachmentRemover(this.attachmentDAO, attachmentFileService);
        this.copyDeleteDeviceAttachments.setAttachmentDuplicator(this.attachmentDuplicator);
        this.copyDeleteDeviceAttachments.setAttachmentRemover(attachmentRemover);
        List attDataCareExtensions = serverPluginManager.get(AttachmentDataCareExtension.class);
        this.attachmentDataCareService.setDependencies(connFactory, attachmentFileService, this.attachmentDAO, attDataCareExtensions);
        this.attachmentRemoverForTicketMaintenance.setAttachmentRemover(attachmentRemover);
        this.attachmentRemoverForDeletedImportedDevices.setAttachmentRemover(attachmentRemover);
        try {
            this.clearTempAttachmentDir();
        }
        catch (IOException e) {
            LOGGER.warn((Object)e);
        }
        AttachmentsServerPlugin.registerAttachmentProtokoll(this.attachmentDAO);
        SEARCH_TAG_ATTACHMENT_NAMES.setAttachmentDAO(this.attachmentDAO);
    }

    public static void registerAttachmentProtokoll(AttachmentDAO dao) {
        AttachmentURLHandler.setAttachmentDAO(dao);
        URLProtocolManager.register((String)"attachment", (URLStreamHandler)new AttachmentURLHandler());
    }

    public void reset() {
    }

    public void restart() {
    }

    protected void clearTempAttachmentDir() throws IOException {
        File file = TempDirectory.ATTACHMENTS_TEMP.toFile();
        IOFunctions.deleteDir((File)file);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

