/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.ticketlist;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.AttachmentData;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.http.utils.MimeTypes;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class TicketAttachmentsContextDependentLoader {
    public TicketAttachmentsContextDependentLoaderResult load(@Nonnull TicketVO ticket, @Nonnull Collection<Integer> reaStepIDs) {
        HashSet<Integer> stepsWithAttachments = new HashSet<Integer>();
        ArrayList<AttachmentData> attachments = new ArrayList<AttachmentData>();
        try {
            HashSet<String> attKeys = new HashSet<String>();
            AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
            HashMap<Integer, List> attachmentsByStepID = new HashMap<Integer, List>();
            if (ticket.isUnbundled() || TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID()).hasResourceAccessToTicket()) {
                List tickets = ticket.isMasterInBundle() ? TicketManager.getReader().getTicketsInBundle(ticket.getBundleID(), true) : Collections.singletonList(ticket);
                for (TicketVO ticketOfGroup : tickets) {
                    Map<AttachmentRow, AttachmentFileRow> fullAttachmentData = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.TicketAttachment, Arrays.asList(ticketOfGroup.getID()));
                    for (AttachmentRow att : fullAttachmentData.keySet()) {
                        Integer stepID;
                        Integer n = stepID = att.getStepId() != null ? att.getStepId() : Integer.valueOf(-1);
                        if (stepID != -1 && !reaStepIDs.contains(stepID)) continue;
                        attachmentsByStepID.computeIfAbsent(stepID, k -> new ArrayList()).add(att);
                    }
                }
            } else {
                List<Integer> tickets;
                long buendelDate;
                if (ticket.isMasterInBundle()) {
                    buendelDate = 0L;
                    tickets = Collections.singletonList(ticket.getID());
                } else {
                    try {
                        buendelDate = this.getDateOfBundling(ticket);
                    }
                    catch (IllegalStateException ex) {
                        buendelDate = Long.MAX_VALUE;
                        AttachmentsServerPlugin.LOGGER.warn((Object)ex);
                    }
                    tickets = Arrays.asList(ticket.getID(), ticket.getBundleID());
                }
                for (int ticketId : tickets) {
                    Map<AttachmentRow, AttachmentFileRow> fullAttachmentData = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.TicketAttachment, Arrays.asList(ticketId));
                    if (fullAttachmentData == null) continue;
                    for (AttachmentRow att : fullAttachmentData.keySet()) {
                        Integer stepID;
                        if (att.getOwnerId().intValue() != ticket.getID() && att.getLastModified() < buendelDate) continue;
                        Integer n = stepID = att.getStepId() != null ? att.getStepId() : Integer.valueOf(-1);
                        if (stepID != -1 && !reaStepIDs.contains(stepID)) continue;
                        attachmentsByStepID.computeIfAbsent(stepID, k -> new ArrayList()).add(att);
                    }
                }
            }
            ArrayList orderedReaStepIDs = new ArrayList(attachmentsByStepID.keySet());
            Collections.sort(orderedReaStepIDs, Comparator.reverseOrder());
            for (Integer stepID : orderedReaStepIDs) {
                for (AttachmentRow att : (List)attachmentsByStepID.get(stepID)) {
                    this.addAttachment(stepsWithAttachments, attachments, attKeys, att);
                }
            }
        }
        catch (Throwable t) {
            AttachmentsServerPlugin.LOGGER.error((Object)("There was error while loading attachment data for ticket: " + String.valueOf(ticket)));
            AttachmentsServerPlugin.LOGGER.error(t);
        }
        Collections.sort(attachments, (a, b) -> {
            int result;
            Integer stepId1 = a.getStepId();
            Integer stepId2 = b.getStepId();
            if (stepId1 == null) {
                stepId1 = -1;
            }
            if (stepId2 == null) {
                stepId2 = -1;
            }
            if ((result = stepId2.compareTo(stepId1)) != 0) {
                return result;
            }
            return Long.valueOf(b.getLastModified()).compareTo(a.getLastModified());
        });
        return new TicketAttachmentsContextDependentLoaderResult(stepsWithAttachments, attachments);
    }

    private void addAttachment(HashSet<Integer> stepsWithAttachments, ArrayList<AttachmentData> attachments, HashSet<String> attKeys, AttachmentRow key) {
        if (key.getStepId() != null) {
            stepsWithAttachments.add(key.getStepId());
        }
        String duplKey = AttachmentFileRow.getFileName(key.getChecksum(), key.getFileLength());
        boolean duplicate = attKeys.contains(duplKey);
        attKeys.add(duplKey);
        String mimeType = MimeTypes.getMimeType((String)key.getFileName());
        attachments.add(new AttachmentData(key.getOwnerId(), key.getStepId(), key.getAdditionalId(), key.getType().getId(), key.getFileName(), mimeType, key.getFileLength(), key.getLastModified(), key.isEmbedded(), duplicate));
    }

    private long getDateOfBundling(TicketVO slaveTicket) {
        List stepsForTicket = TicketManager.getReaderForSystem().getReaStepsForTicket(slaveTicket.getID());
        for (ReaStepVO reaStepVO : stepsForTicket) {
            if (reaStepVO.getActionID() != -1) continue;
            return reaStepVO.getEndDate();
        }
        throw new IllegalStateException(String.format("Cannot find a step where ticket %d was bundled!", slaveTicket.getID()));
    }

    public static class TicketAttachmentsContextDependentLoaderResult {
        private HashSet<Integer> stepsWithAttachments;
        private ArrayList<AttachmentData> attachments;

        public TicketAttachmentsContextDependentLoaderResult(HashSet<Integer> stepsWithAttachments, ArrayList<AttachmentData> attachments) {
            this.stepsWithAttachments = stepsWithAttachments;
            this.attachments = attachments;
        }

        public HashSet<Integer> getStepsWithAttachments() {
            return this.stepsWithAttachments;
        }

        public ArrayList<AttachmentData> getAttachments() {
            return this.attachments;
        }
    }
}

