/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.mail;

import java.io.StringWriter;

public class HtmlEncoder {
    public static String encode(String text, boolean needSpacesEncoding) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        char[] chars = text.toCharArray();
        StringWriter out = new StringWriter();
        HtmlEncoder.encode(out, chars, 0, chars.length, needSpacesEncoding);
        return out.toString();
    }

    private static void encode(StringWriter out, char[] chars, int start, int length, boolean needSpacesEncoding) {
        int last = start;
        int end = length + start;
        for (int i = start; i < end; ++i) {
            String encodedData = null;
            char ch = chars[i];
            switch (ch) {
                case '<': {
                    encodedData = "&lt;";
                    break;
                }
                case '>': {
                    encodedData = "&gt;";
                    break;
                }
                case '&': {
                    encodedData = "&amp;";
                    break;
                }
                case '\"': {
                    encodedData = "&quot;";
                    break;
                }
                case '\u00a0': {
                    encodedData = "&nbsp;";
                    break;
                }
                case ' ': {
                    if (!needSpacesEncoding) break;
                    encodedData = "&nbsp;";
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (ch >= ' ' && ch <= '\u007f') break;
                    if (i > last) {
                        out.write(chars, last, i - last);
                    }
                    last = i + 1;
                    out.write("&#");
                    out.write(String.valueOf((int)ch));
                    out.write(59);
                }
            }
            if (encodedData == null) continue;
            if (i > last) {
                out.write(chars, last, i - last);
            }
            last = i + 1;
            out.write(encodedData);
        }
        if (last < end) {
            out.write(chars, last, end - last);
        }
    }
}

