/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.extensions;

import com.inet.editor.HtmlConverter;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdderImpl;
import com.inet.helpdesk.plugins.attachments.server.TicketAttachmentService;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TicketAttachmentAdder {
    public String addAttachmentsToTicket(int ticketId, int stepId, String stepContent, List<LargeContent> attachments, List<String> addedAttachmentFileNames) {
        TicketAttachmentService service = (TicketAttachmentService)ServerPluginManager.getInstance().getSingleInstance(TicketAttachmentProvider.class);
        HashMap<String, String> imageMap = new HashMap<String, String>();
        for (LargeContent att : attachments) {
            if (att.getContentType() == AttachmentType.Signature || att.getContentType() == AttachmentType.Unknown) continue;
            AttachmentDescription desc = new AttachmentDescription();
            desc.setFileName(att.getName());
            desc.setLastModified(att.getLastModified() > 0L ? att.getLastModified() : System.currentTimeMillis());
            desc.setOwnerId(ticketId);
            desc.setStepId(stepId);
            InputStream fin = null;
            try {
                fin = att.getContent();
                if (fin == null) {
                    throw new IOException("Could not get input stream of attachment with name \"" + att.getName() + "\"");
                }
                desc = service.addFile(desc, fin, att.getContentType());
                if (att.getContentType() == AttachmentType.EmbeddedImage) {
                    imageMap.put(att.getName(), desc.getRESTfulFilePath());
                }
                addedAttachmentFileNames.add(desc.getFileName());
            }
            catch (IOException exc) {
                throw new PersistenceException((Throwable)exc);
            }
            finally {
                if (fin == null) continue;
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (imageMap.size() > 0) {
            return HtmlConverter.getCompactHtmlText((String)stepContent, imageMap, imageMap, null, (boolean)false);
        }
        return null;
    }

    public String addAttachmentsToTicket(int ticketId, int stepId, String stepContent, List<LargeContent> attachments) {
        return this.addAttachmentsToTicket(ticketId, stepId, stepContent, attachments, new ArrayList<String>());
    }

    public String convertExternalImagesToAttachments(int ticketId, int stepId, String stepContent) {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
        TicketAttachmentService ticketAttService = (TicketAttachmentService)spm.getSingleInstance(TicketAttachmentProvider.class);
        ExternalImageAttachmentAdderImpl adder = new ExternalImageAttachmentAdderImpl(attService, ticketAttService);
        return adder.convertExternalImagesToAttachments(AttachmentOwnerType.TicketAttachment, ticketId, stepId, stepContent);
    }
}

