/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import com.inet.helpdesk.plugins.attachments.server.DirectoryTreeManager;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentFileChecker;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.persistence.PersistenceEntry;

public class UnmanagedAttachmentFilesFinder {
    private AttachmentFileChecker attFileChecker;

    public UnmanagedAttachmentFilesFinder(AttachmentFileChecker attFileChecker) {
        ValidationUtils.throwExceptionIfNull(attFileChecker, "attFileChecker");
        this.attFileChecker = attFileChecker;
    }

    public void executeOnUnmanagedAttachmentFiles(PersistenceEntry attachmentDirectory, OperationToExecuteOnUnmanagedAttachment operation) {
        ValidationUtils.throwExceptionIfNull(operation, "operation");
        ValidationUtils.throwExceptionIfNull(attachmentDirectory, "attachmentDirectory");
        OperationToExecuteOnBranchOrNode processNodeOperation = (nodeDir, attDir) -> this.processNode(nodeDir, attDir, operation);
        OperationToExecuteOnBranchOrNode processBranchOperation = (branchDir, attDir) -> this.processDirectory(branchDir, attDir, processNodeOperation);
        this.processDirectory(attachmentDirectory, attachmentDirectory, processBranchOperation);
    }

    private void processDirectory(PersistenceEntry directoryToProcess, PersistenceEntry attachmentDirectory, OperationToExecuteOnBranchOrNode operation) {
        for (PersistenceEntry dir : directoryToProcess.getChildren()) {
            if (!DirectoryTreeManager.isBranchOrNodeDirectory(dir)) continue;
            operation.execute(dir, attachmentDirectory);
        }
    }

    private void processNode(PersistenceEntry nodeDir, PersistenceEntry attachmentDirectory, OperationToExecuteOnUnmanagedAttachment operation) {
        for (PersistenceEntry file : nodeDir.getChildren()) {
            if (this.attFileChecker.isManagedAttachmentFile(attachmentDirectory, file)) continue;
            operation.execute(file);
        }
    }

    public static interface OperationToExecuteOnUnmanagedAttachment {
        public void execute(PersistenceEntry var1);
    }

    private static interface OperationToExecuteOnBranchOrNode {
        public void execute(PersistenceEntry var1, PersistenceEntry var2);
    }
}

