/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketDeletionMaintenanceListener;
import com.inet.helpdesk.plugins.attachments.server.AttachmentRemover;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import java.util.Collections;
import java.util.List;

public class AttachmentRemoverForTicketMaintenance
implements TicketDeletionMaintenanceListener {
    private AttachmentRemover attachmentRemover;

    public void setAttachmentRemover(AttachmentRemover attachmentRemover) {
        ValidationUtils.throwExceptionIfNull(attachmentRemover, "attachment remover");
        this.attachmentRemover = attachmentRemover;
    }

    public void ticketsDeleted(List<Integer> deletedTicketIds) throws ServerDataException {
        if (this.attachmentRemover == null) {
            throw new IllegalStateException("mandatory dependency attachmentRemover is not set");
        }
        for (int ticketID : deletedTicketIds) {
            Object oldNames = AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.getValue(ticketID);
            AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(ticketID, (List<String>)oldNames, Collections.emptyList());
        }
        this.attachmentRemover.removeAllUnrelatedTicketAttachmentsAndAllUnrelatedAttachmentFiles();
    }
}

