/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.datacare.UnrelatedAttachmentData;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.PreviewEntry;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.objects.FileSizeObject;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

@JsonData
public class AttachmentPreviewEntry
extends PreviewEntry<UnrelatedAttachmentData> {
    public AttachmentPreviewEntry from(UnrelatedAttachmentData value) throws ServerDataException {
        AttachmentPreviewEntry entry = new AttachmentPreviewEntry();
        entry.setTitle(value.getFileName());
        ArrayList<LocalizedKey> details = new ArrayList<LocalizedKey>();
        String attachmentTypeDisplayName = value.getAttachmentTypeDisplayName();
        if (attachmentTypeDisplayName == null) {
            attachmentTypeDisplayName = AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.detail.type." + value.getAttachmentType(), new Object[0]);
        }
        details.add(new LocalizedKey(AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.detail.type", new Object[0]), attachmentTypeDisplayName));
        details.add(new LocalizedKey(AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.detail.size", new Object[0]), this.getReadableFilesize(value.getSize())));
        if (value.getLastModified() != null) {
            details.add(new LocalizedKey(AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.detail.lastmodified", new Object[0]), this.getReadableDate(value.getLastModified())));
        }
        entry.setDetails(details);
        String ext = value.getFileName();
        int index = ext.lastIndexOf(46);
        if (index >= 0) {
            ext = ext.substring(index);
        }
        entry.setIcon("images/mimetypebyname/file" + ext + "?size=64");
        return entry;
    }

    private String getReadableDate(long lastModified) {
        DateFormat dateTimeInstance = DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale());
        return dateTimeInstance.format(new Date(lastModified));
    }

    private String getReadableFilesize(long size) {
        return new FileSizeObject(Long.valueOf(size), ClientLocale.getThreadLocale()).toString();
    }
}

