/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.utils.StringConcatenator;
import com.inet.helpdesk.core.utils.SubListTaskExecutor;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAOWithCache;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDbDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentFileService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ChecksumUtils;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCare;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentFileChecker;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentPreviewEntryDistributionBalancer;
import com.inet.helpdesk.plugins.attachments.server.datacare.FoundAttachmentsWithMissingFiles;
import com.inet.helpdesk.plugins.attachments.server.datacare.FoundUnrelatedAttachments;
import com.inet.helpdesk.plugins.attachments.server.datacare.UnmanagedAttachmentFilesFinder;
import com.inet.helpdesk.plugins.attachments.server.datacare.UnrelatedAttachmentData;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.persistence.PersistenceEntry;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.SuppressFBWarnings;

public class AttachmentDataCareService
implements AttachmentDataCare {
    private static final int MAX_NUMBER_OF_FOUND_ATTACHMENTS_REFERENCING_MISSING_FILES = 1000;
    private static final int SELECTED_EXEMPLARY_ENTRIES_LIMIT = 6;
    private ConnectionFactory connectionFactory;
    private AttachmentFileService attFileService;
    private AttachmentDAOWithCache attachmentDAO;
    private List<AttachmentDataCareExtension> extensions;
    private AttachmentPreviewEntryDistributionBalancer previewEntryDistributionBalancer;

    public void setDependencies(ConnectionFactory connectionFactory, AttachmentFileService attFileService, AttachmentDAOWithCache attachmentDAO, List<AttachmentDataCareExtension> extensions) {
        this.connectionFactory = this.throwIfNull(connectionFactory, "connectionFactory");
        this.attFileService = this.throwIfNull(attFileService, "attFileService");
        this.attachmentDAO = this.throwIfNull(attachmentDAO, "attachmentDAO");
        extensions = new ArrayList<AttachmentDataCareExtension>((Collection)this.throwIfNull(extensions, "extensions"));
        extensions.sort((o1, o2) -> Integer.compare(o1.getAttachmentType().getId(), o2.getAttachmentType().getId()));
        this.extensions = Collections.unmodifiableList(extensions);
        this.previewEntryDistributionBalancer = new AttachmentPreviewEntryDistributionBalancer(6);
    }

    private <T> T throwIfNull(T toCheck, String name) {
        if (toCheck == null) {
            throw new IllegalArgumentException(name + " must not be null");
        }
        return toCheck;
    }

    private void throwIfMandatoryDependenciesAreNotProvided() {
        if (this.connectionFactory == null) {
            throw new IllegalStateException("mandatory dependency connection factory must not be null");
        }
        if (this.attFileService == null) {
            throw new IllegalStateException("mandatory dependency attachment file service must not be null");
        }
        if (this.attachmentDAO == null) {
            throw new IllegalStateException("mandatory dependency attachmentDAO must not be null");
        }
        if (this.extensions == null) {
            throw new IllegalStateException("mandatory dependency extensions must not be null");
        }
    }

    @Override
    public synchronized FoundUnrelatedAttachments findUnrelatedAttachments() throws ServerDataException {
        FoundUnrelatedAttachments foundUnrelatedAttachments;
        block11: {
            this.throwIfMandatoryDependenciesAreNotProvided();
            Connection connection = this.connectionFactory.getConnection();
            try {
                ArrayList<List<Integer>> foundAttachmentIDs = new ArrayList<List<Integer>>();
                for (AttachmentDataCareExtension ext : this.extensions) {
                    List<Integer> attIDs = ext.findUnrelatedAttachments(connection);
                    foundAttachmentIDs.add(attIDs);
                }
                List<AttachmentFileRow> unrelatedAttachmentFiles = this.attachmentDAO.getAttachmentFilesWhichAreNotReferencedByAttachments();
                List<PersistenceEntry> unmanagedAttachmentFiles = this.findUnmanagedAttachmentFiles();
                int[] attCounts = new int[foundAttachmentIDs.size() + 1];
                for (int index = 0; index < foundAttachmentIDs.size(); ++index) {
                    attCounts[index] = ((List)foundAttachmentIDs.get(index)).size();
                }
                attCounts[foundAttachmentIDs.size()] = unrelatedAttachmentFiles.size() + unmanagedAttachmentFiles.size();
                int[] balancedDistribution = this.previewEntryDistributionBalancer.balance(attCounts);
                ArrayList<UnrelatedAttachmentData> exemplaryAttachments = new ArrayList<UnrelatedAttachmentData>();
                for (int index = 0; index < foundAttachmentIDs.size(); ++index) {
                    AttachmentOwnerType type = this.extensions.get(index).getAttachmentType();
                    List attIDs = (List)foundAttachmentIDs.get(index);
                    ArrayList<UnrelatedAttachmentData> data = this.createExemplaryData(connection, type, attIDs, balancedDistribution[index]);
                    exemplaryAttachments.addAll(data);
                }
                ArrayList<UnrelatedAttachmentData> exemplaryAttachmentFiles = this.createExemplaryDataForAttachmentFiles(unrelatedAttachmentFiles, unmanagedAttachmentFiles, balancedDistribution[foundAttachmentIDs.size()]);
                exemplaryAttachments.addAll(exemplaryAttachmentFiles);
                int foundAttachmentFilesCount = attCounts[foundAttachmentIDs.size()];
                int foundAttachmentsCount = IntStream.of(attCounts).sum() - foundAttachmentFilesCount;
                foundUnrelatedAttachments = new FoundUnrelatedAttachments(foundAttachmentsCount, foundAttachmentFilesCount, exemplaryAttachments);
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new ServerDataException(ex);
                }
            }
            connection.close();
        }
        return foundUnrelatedAttachments;
    }

    @Override
    public synchronized void deleteUnrelatedAttachments() throws ServerDataException {
        this.throwIfMandatoryDependenciesAreNotProvided();
        try (Connection connection = this.connectionFactory.getConnection();){
            ArrayList<Integer> allUnrelatedAttachmentIds = new ArrayList<Integer>();
            for (AttachmentDataCareExtension ext : this.extensions) {
                List<Integer> attIDs = ext.findUnrelatedAttachments(connection);
                allUnrelatedAttachmentIds.addAll(attIDs);
            }
            this.deleteAttachmentsById(connection, allUnrelatedAttachmentIds);
            List<AttachmentFileRow> attFileRows = this.attachmentDAO.getAttachmentFilesWhichAreNotReferencedByAttachments();
            for (AttachmentFileRow attFile : attFileRows) {
                this.attachmentDAO.removeAttachmentFile(attFile.getChecksum(), attFile.getFileLength());
                this.attFileService.deleteFile(attFile.getFilePath());
            }
            this.deleteUnmanagedAttachmentFiles();
        }
        catch (Exception ex) {
            throw new ServerDataException(ex);
        }
    }

    private void deleteAttachmentsById(final Connection connection, List<Integer> attachmentIds) throws SQLException {
        try {
            new SubListTaskExecutor().executeForEachSubList(attachmentIds, 900, (SubListTaskExecutor.SubListExecutionTask)new SubListTaskExecutor.SubListExecutionTask<Integer>(){

                @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument 'ids' is self constructed from integers")
                public void execute(List<Integer> subList) throws Exception {
                    Object ids = subList.toString();
                    ids = "(" + ((String)ids).substring(1, ((String)ids).length() - 1) + ")";
                    String sql = String.format("DELETE FROM tblAttachments WHERE attachmentId IN %s", ids);
                    try (PreparedStatement pstm = connection.prepareStatement(sql);){
                        pstm.executeUpdate();
                    }
                }
            });
        }
        catch (Exception ex) {
            throw (SQLException)ex;
        }
    }

    private ArrayList<UnrelatedAttachmentData> createExemplaryData(final Connection connection, final AttachmentOwnerType type, List<Integer> attachmentIds, final int entryLimit) throws SQLException, UnsupportedEncodingException {
        if (attachmentIds.isEmpty() || entryLimit <= 0) {
            return new ArrayList<UnrelatedAttachmentData>();
        }
        Collections.sort(attachmentIds, Collections.reverseOrder());
        final ArrayList<UnrelatedAttachmentData> exemplaryAttachments = new ArrayList<UnrelatedAttachmentData>();
        try {
            new SubListTaskExecutor().executeForEachSubList(attachmentIds, 900, (SubListTaskExecutor.SubListExecutionTask)new SubListTaskExecutor.SubListExecutionTask<Integer>(){

                @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument 'ids' is self constructed")
                public void execute(List<Integer> subList) throws Exception {
                    if (exemplaryAttachments.size() >= entryLimit) {
                        return;
                    }
                    Object ids = subList.toString();
                    ids = "(" + ((String)ids).substring(1, ((String)ids).length() - 1) + ")";
                    String sql = "SELECT attachmentId, fileName, lastModified, filelength FROM tblAttachments LEFT OUTER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId WHERE attachmentId IN " + (String)ids + " ORDER BY tblAttachments.attachmentId DESC";
                    try (PreparedStatement pstm = connection.prepareStatement(sql);
                         ResultSet rs = pstm.executeQuery();){
                        while (rs.next()) {
                            if (exemplaryAttachments.size() >= entryLimit) {
                                break;
                            }
                            int attID = rs.getInt(1);
                            String fileName = new String(rs.getBytes(2), "UTF-8");
                            long lastModified = rs.getLong(3);
                            long filelength = rs.getLong(4);
                            UnrelatedAttachmentData attData = new UnrelatedAttachmentData(type.getAttachmentSubContext(), type.getDisplayName(), fileName, lastModified, filelength);
                            exemplaryAttachments.add(attData);
                            String debugMsg = String.format("Unreferenced attachment of type \"%s\" with file name \"%s\" has ID \"%d\".", type.getAttachmentSubContext(), fileName, attID);
                            AttachmentsServerPlugin.LOGGER.debug((Object)debugMsg);
                        }
                    }
                }
            });
            return exemplaryAttachments;
        }
        catch (Exception ex) {
            if (ex instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)ex;
            }
            throw (SQLException)ex;
        }
    }

    private ArrayList<UnrelatedAttachmentData> createExemplaryDataForAttachmentFiles(List<AttachmentFileRow> unrelatedAttachmentFiles, List<PersistenceEntry> unmanagedAttachmentFiles, int entryLimit) {
        boolean areBothListsEmpty;
        boolean bl = areBothListsEmpty = unrelatedAttachmentFiles.isEmpty() && unmanagedAttachmentFiles.isEmpty();
        if (areBothListsEmpty || entryLimit <= 0) {
            return new ArrayList<UnrelatedAttachmentData>();
        }
        ArrayList<UnrelatedAttachmentData> exemplaryAttachmentFiles = new ArrayList<UnrelatedAttachmentData>();
        for (AttachmentFileRow attFile : unrelatedAttachmentFiles) {
            if (exemplaryAttachmentFiles.size() >= entryLimit) break;
            exemplaryAttachmentFiles.add(this.createExemplaryData(attFile));
        }
        for (PersistenceEntry file : unmanagedAttachmentFiles) {
            if (exemplaryAttachmentFiles.size() >= entryLimit) break;
            long fileLastModified = file.lastModified();
            Long lastModified = fileLastModified == 0L ? null : Long.valueOf(fileLastModified);
            UnrelatedAttachmentData attData = new UnrelatedAttachmentData("unknown", AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.detail.type.unknown", new Object[0]), file.getName(), lastModified, file.size());
            exemplaryAttachmentFiles.add(attData);
        }
        return exemplaryAttachmentFiles;
    }

    private List<PersistenceEntry> findUnmanagedAttachmentFiles() throws SQLException {
        ArrayList<PersistenceEntry> unmanagedAttachmentFiles = new ArrayList<PersistenceEntry>();
        UnmanagedAttachmentFilesFinder.OperationToExecuteOnUnmanagedAttachment operation = unmanagedAttFile -> unmanagedAttachmentFiles.add(unmanagedAttFile);
        AttachmentFileChecker attFileChecker = new AttachmentFileChecker(this.attachmentDAO.getAllAttachmentFiles());
        UnmanagedAttachmentFilesFinder finder = new UnmanagedAttachmentFilesFinder(attFileChecker);
        finder.executeOnUnmanagedAttachmentFiles(AppDataLocation.getAttachmentDirectory(), operation);
        return unmanagedAttachmentFiles;
    }

    private void deleteUnmanagedAttachmentFiles() throws SQLException {
        UnmanagedAttachmentFilesFinder.OperationToExecuteOnUnmanagedAttachment operation = unmanagedAttachmentFile -> unmanagedAttachmentFile.deleteTree();
        AttachmentFileChecker attFileChecker = new AttachmentFileChecker(this.attachmentDAO.getAllAttachmentFiles());
        UnmanagedAttachmentFilesFinder finder = new UnmanagedAttachmentFilesFinder(attFileChecker);
        finder.executeOnUnmanagedAttachmentFiles(AppDataLocation.getAttachmentDirectory(), operation);
    }

    private Map<String, List<AttachmentFileRow>> groupByDirectoryPath(Map<AttachmentFileRow, Integer> attFilesWithReferenceCount) {
        HashMap<String, List<AttachmentFileRow>> result = new HashMap<String, List<AttachmentFileRow>>();
        for (Map.Entry<AttachmentFileRow, Integer> entry : attFilesWithReferenceCount.entrySet()) {
            AttachmentFileRow attFile = entry.getKey();
            String dirPath = attFile.getDirectoryPath();
            ArrayList<AttachmentFileRow> groupedAttFiles = (ArrayList<AttachmentFileRow>)result.get(dirPath);
            if (groupedAttFiles == null) {
                groupedAttFiles = new ArrayList<AttachmentFileRow>();
                result.put(dirPath, groupedAttFiles);
            }
            groupedAttFiles.add(attFile);
        }
        return result;
    }

    private boolean removeAttachmentsWithMissingFilesFromMap(Map<AttachmentFileRow, Integer> attFilesWithReferenceCount) {
        Map<String, List<AttachmentFileRow>> attFilesGroupedByDirPath = this.groupByDirectoryPath(attFilesWithReferenceCount);
        int missingFilesCount = 0;
        boolean foundMore = false;
        for (String dirPath : attFilesGroupedByDirPath.keySet()) {
            if (foundMore) {
                attFilesGroupedByDirPath.get(dirPath).stream().forEach(e -> attFilesWithReferenceCount.remove(e));
                continue;
            }
            File dir = AppDataLocation.getBaseLocationPath().resolve("Attachments").resolve(dirPath.substring(1)).toFile();
            HashSet<String> fileNames = new HashSet<String>(Arrays.asList(dir.list()));
            for (AttachmentFileRow attFileInDir : attFilesGroupedByDirPath.get(dirPath)) {
                if (foundMore || fileNames.contains(attFileInDir.getFileName())) {
                    attFilesWithReferenceCount.remove(attFileInDir);
                    continue;
                }
                if (++missingFilesCount <= 1000) continue;
                foundMore = true;
                attFilesWithReferenceCount.remove(attFileInDir);
            }
        }
        return foundMore;
    }

    @Override
    public synchronized FoundAttachmentsWithMissingFiles findAttachmentsWithMissingFiles() throws ServerDataException {
        try {
            Map<AttachmentFileRow, Integer> attFilesWithReferenceCount = this.attachmentDAO.getAllAttachmentFilesWithReferenceCount();
            boolean foundMore = this.removeAttachmentsWithMissingFilesFromMap(attFilesWithReferenceCount);
            int foundAttachmentFilesCount = attFilesWithReferenceCount.size();
            ArrayList<UnrelatedAttachmentData> exemplaryAttachments = new ArrayList<UnrelatedAttachmentData>();
            List<AttachmentFileRow> attFilesWithReferences = this.getAttFilesWithReferences(attFilesWithReferenceCount.entrySet(), 6);
            ArrayList<AttachmentFileRow> attFilesWithoutReferences = new ArrayList<AttachmentFileRow>();
            int attachmentFileLimit = 6 - attFilesWithReferences.size();
            if (attachmentFileLimit > 0) {
                attFilesWithoutReferences.addAll(this.getAttFilesWithoutReferences(attFilesWithReferenceCount.entrySet(), attachmentFileLimit));
            }
            int attachmentLimit = 6 - attFilesWithoutReferences.size();
            HashMap<AttachmentFileRow, List<AttachmentRow>> attFileToAtts = new HashMap<AttachmentFileRow, List<AttachmentRow>>();
            for (AttachmentFileRow attFile : attFilesWithReferences) {
                List<AttachmentRow> attachments = this.attachmentDAO.getAttachmentsForFile(attFile.getChecksum(), attFile.getFileLength(), attachmentLimit);
                attFileToAtts.put(attFile, attachments);
            }
            for (AttachmentRow attachment : this.getAttachments(attFileToAtts.values(), attachmentLimit)) {
                exemplaryAttachments.add(this.createExemplaryData(attachment));
            }
            for (AttachmentFileRow attFile : attFilesWithoutReferences) {
                exemplaryAttachments.add(this.createExemplaryData(attFile));
            }
            return new FoundAttachmentsWithMissingFiles(foundAttachmentFilesCount, foundMore, exemplaryAttachments);
        }
        catch (SQLException ex) {
            throw new ServerDataException((Exception)ex);
        }
    }

    private List<AttachmentRow> getAttachments(Collection<List<AttachmentRow>> listsWithAttachments, int attachmentLimit) {
        List<AttachmentRow> attachments;
        ArrayList<AttachmentRow> result = new ArrayList<AttachmentRow>();
        int index = 0;
        while (result.size() < attachmentLimit && !(attachments = this.getAttachmentsAtIndex(listsWithAttachments, index)).isEmpty()) {
            result.addAll(attachments);
            ++index;
        }
        return result.subList(0, Math.min(attachmentLimit, result.size()));
    }

    private List<AttachmentRow> getAttachmentsAtIndex(Collection<List<AttachmentRow>> listsWithAttachments, int index) {
        ArrayList<AttachmentRow> result = new ArrayList<AttachmentRow>();
        for (List<AttachmentRow> attachments : listsWithAttachments) {
            if (attachments.size() <= index) continue;
            result.add(attachments.get(index));
        }
        return result;
    }

    private List<AttachmentFileRow> getAttFilesWithoutReferences(Set<Map.Entry<AttachmentFileRow, Integer>> entrySetOfAttFilesWithReferenceCount, int entryLimit) {
        return this.getAttFiles(entrySetOfAttFilesWithReferenceCount, entryLimit, false);
    }

    private List<AttachmentFileRow> getAttFilesWithReferences(Set<Map.Entry<AttachmentFileRow, Integer>> entrySetOfAttFilesWithReferenceCount, int entryLimit) {
        return this.getAttFiles(entrySetOfAttFilesWithReferenceCount, entryLimit, true);
    }

    private List<AttachmentFileRow> getAttFiles(Set<Map.Entry<AttachmentFileRow, Integer>> entrySetOfAttFilesWithReferenceCount, int entryLimit, boolean withReferences) {
        ArrayList<AttachmentFileRow> attachmentFiles = new ArrayList<AttachmentFileRow>();
        for (Map.Entry<AttachmentFileRow, Integer> entry : entrySetOfAttFilesWithReferenceCount) {
            boolean skipAttFileWithoutReferences;
            if (attachmentFiles.size() >= entryLimit) break;
            boolean skipAttFileWithReferences = !withReferences && entry.getValue() > 0;
            boolean bl = skipAttFileWithoutReferences = withReferences && entry.getValue() == 0;
            if (skipAttFileWithReferences || skipAttFileWithoutReferences) continue;
            attachmentFiles.add(entry.getKey());
        }
        return attachmentFiles;
    }

    private UnrelatedAttachmentData createExemplaryData(AttachmentRow attachment) {
        return new UnrelatedAttachmentData(attachment.getType().getAttachmentSubContext(), attachment.getType().getDisplayName(), attachment.getFileName(), attachment.getLastModified(), attachment.getFileLength());
    }

    private UnrelatedAttachmentData createExemplaryData(AttachmentFileRow attachmentFile) {
        PersistenceEntry file = this.attFileService.getAttachmentFile(attachmentFile.getFilePath());
        long fileLastModified = file.lastModified();
        Long lastModified = fileLastModified == 0L ? null : Long.valueOf(fileLastModified);
        return new UnrelatedAttachmentData("unknown", AttachmentsServerPlugin.MSG.getMsg("datacare.attachment.detail.type.unknown", new Object[0]), attachmentFile.getFileName(), lastModified, attachmentFile.getFileLength());
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument 'ids' is self constructed from integers")
    public synchronized void deleteAttachmentsWithMissingFiles() throws ServerDataException {
        try (final Connection con = this.connectionFactory.getConnection();){
            Map<AttachmentFileRow, Integer> attFileRowToAttFileId = this.readAttachmentFiles(con);
            List<Integer> attFilesToDelete = this.idsOfNonExistingAttachmentFiles(attFileRowToAttFileId);
            final HashMap ticketIdToAttInfos = new HashMap();
            new SubListTaskExecutor().executeForEachSubList(attFilesToDelete, 900, (SubListTaskExecutor.SubListExecutionTask)new SubListTaskExecutor.SubListExecutionTask<Integer>(){

                @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument 'ids' is self constructed from integers")
                public void execute(List<Integer> subList) throws Exception {
                    String ids = subList.stream().map(val -> val.toString()).collect(Collectors.joining(", "));
                    String sql = String.format("SELECT attachmentId, ownerId, fileName FROM tblAttachments WHERE type=%d AND attachmentFileId IN (%s)", AttachmentOwnerType.TicketAttachment.getId(), ids);
                    try (Statement stm = con.createStatement();
                         ResultSet rs = stm.executeQuery(sql);){
                        while (rs.next()) {
                            int attID = rs.getInt(1);
                            int ownerID = rs.getInt(2);
                            String fileName = AttachmentDbDAO.bytesToStr(rs.getBytes(3));
                            ArrayList<AttInfo> attInfos = (ArrayList<AttInfo>)ticketIdToAttInfos.get(ownerID);
                            if (attInfos == null) {
                                attInfos = new ArrayList<AttInfo>();
                                ticketIdToAttInfos.put(ownerID, attInfos);
                            }
                            attInfos.add(new AttInfo(attID, fileName));
                        }
                    }
                }
            });
            Iterator iterator = ticketIdToAttInfos.keySet().iterator();
            while (iterator.hasNext()) {
                String allAttFileNames;
                int ticketID = (Integer)iterator.next();
                Integer ownerID = ticketID;
                List attInfos = (List)ticketIdToAttInfos.get(ownerID);
                List attachmentIDs = attInfos.stream().map(AttInfo::getAttachmentID).collect(Collectors.toList());
                new SubListTaskExecutor().executeForEachSubList(attachmentIDs, 900, (SubListTaskExecutor.SubListExecutionTask)new SubListTaskExecutor.SubListExecutionTask<Integer>(){

                    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument 'ids' is self constructed from integers")
                    public void execute(List<Integer> subList) throws Exception {
                        String ids = subList.stream().map(val -> val.toString()).collect(Collectors.joining(", "));
                        try (Statement stm = con.createStatement();){
                            stm.executeUpdate("DELETE FROM tblAttachments WHERE attachmentId IN (" + ids + ")");
                        }
                    }
                });
                this.attachmentDAO.clearAttachmentFileNames(AttachmentOwnerType.TicketAttachment, ownerID);
                List<String> listOfAttFileNames = attInfos.stream().map(AttInfo::getFileName).collect(Collectors.toList());
                String stepDesc = allAttFileNames = listOfAttFileNames.stream().collect(Collectors.joining(", "));
                ReaStepTextVO stepText = ReaStepTextVO.empty();
                int maxDescLength = 255;
                if (stepDesc.length() > maxDescLength) {
                    stepDesc = StringConcatenator.concatAndShortenIfNeeded(listOfAttFileNames, (int)maxDescLength);
                    stepText = ReaStepTextVO.of((String)allAttFileNames, (boolean)false);
                }
                TicketManager.getMaintenance().applyActionAnlageLoeschen(ticketID, stepText, stepDesc);
                AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(ticketID, listOfAttFileNames, Collections.emptyList());
            }
            new SubListTaskExecutor().executeForEachSubList(attFilesToDelete, 900, (SubListTaskExecutor.SubListExecutionTask)new SubListTaskExecutor.SubListExecutionTask<Integer>(){
                final String sqlSelectNonTicketAttachments = "SELECT DISTINCT ownerId, type FROM tblAttachments WHERE type <> " + AttachmentOwnerType.TicketAttachment.getId() + " AND attachmentFileId IN ";
                final String sqlDeleteNonTicketAttachments = "DELETE FROM tblAttachments WHERE type <> " + AttachmentOwnerType.TicketAttachment.getId() + " AND attachmentFileId IN ";
                final String sqlDeleteAttachmentFiles = "DELETE FROM tblAttachmentFiles WHERE attachmentFileId IN ";

                @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument 'ids' is self constructed from integers")
                public void execute(List<Integer> subList) throws Exception {
                    Object ids = subList.toString();
                    ids = "(" + ((String)ids).substring(1, ((String)ids).length() - 1) + ")";
                    try (PreparedStatement pstmSelectNonTicketAttachments = con.prepareStatement(this.sqlSelectNonTicketAttachments + (String)ids);
                         PreparedStatement pstmDeleteNonTicketAttachments = con.prepareStatement(this.sqlDeleteNonTicketAttachments + (String)ids);
                         PreparedStatement pstmDeleteAttachmentFiles = con.prepareStatement("DELETE FROM tblAttachmentFiles WHERE attachmentFileId IN " + (String)ids);){
                        try (ResultSet rs = pstmSelectNonTicketAttachments.executeQuery();){
                            while (rs.next()) {
                                Integer ownerID = rs.getInt(1);
                                AttachmentOwnerType type = AttachmentOwnerType.getTypeForId(rs.getInt(2));
                                AttachmentDataCareService.this.attachmentDAO.clearAttachmentFileNames(type, ownerID);
                            }
                        }
                        pstmDeleteNonTicketAttachments.executeUpdate();
                        pstmDeleteAttachmentFiles.executeUpdate();
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new ServerDataException(ex);
        }
    }

    private Map<AttachmentFileRow, Integer> readAttachmentFiles(Connection con) throws SQLException {
        HashMap<AttachmentFileRow, Integer> attFileRowToAttFileId = new HashMap<AttachmentFileRow, Integer>();
        String sql = "SELECT attachmentFileId, checksum, filelength, parentDirectoryPath FROM tblAttachmentFiles";
        try (PreparedStatement pstm = con.prepareStatement(sql);
             ResultSet rs = pstm.executeQuery();){
            while (rs.next()) {
                int attFileId = rs.getInt(1);
                String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(2));
                long fileLength = rs.getLong(3);
                String path = rs.getString(4);
                attFileRowToAttFileId.put(new AttachmentFileRow(checksum, path, fileLength), attFileId);
            }
        }
        return attFileRowToAttFileId;
    }

    private List<Integer> idsOfNonExistingAttachmentFiles(Map<AttachmentFileRow, Integer> attFileRowToAttFileId) {
        ArrayList<Integer> attFilesToDelete = new ArrayList<Integer>();
        for (Map.Entry<AttachmentFileRow, Integer> entry : attFileRowToAttFileId.entrySet()) {
            if (this.attFileService.exists(entry.getKey().getFilePath())) continue;
            attFilesToDelete.add(entry.getValue());
        }
        return attFilesToDelete;
    }

    private static class AttInfo {
        private final int attachmentID;
        private final String fileName;

        public AttInfo(int attachmentID, String fileName) {
            this.attachmentID = attachmentID;
            this.fileName = fileName;
        }

        public int getAttachmentID() {
            return this.attachmentID;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

