/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.core.error.HDErrors;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.TicketReaderBase;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.utils.StringConcatenator;
import com.inet.helpdesk.plugins.attachments.server.AddAttachmentsServiceMethod;
import com.inet.helpdesk.plugins.attachments.server.AttachmentRecognizer;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdderImpl;
import com.inet.helpdesk.plugins.attachments.server.PreConditionCheckerForAttachmentServices;
import com.inet.helpdesk.plugins.attachments.server.TicketDAO;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.server.extensions.DeleteAttachmentExtension;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescriptionList;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.shared.http.upload.AttachmentType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TicketAttachmentService
implements TicketAttachmentProvider {
    private AttachmentService attachmentService;
    private AttachmentRecognizer attachmentRecognizer;
    private PreConditionCheckerForAttachmentServices preConditionChecker;
    private Supplier<TicketReaderBase> ticketReaderProvider;
    private Supplier<TicketManipulator> ticketManipulatorProvider;
    private Function<Integer, ActionVO> actionProvider;
    private TicketDAO ticketDAO;

    public TicketAttachmentService(AttachmentService attachmentService, AttachmentRecognizer attachmentRecognizer, PreConditionCheckerForAttachmentServices preConditionChecker) {
        ValidationUtils.throwExceptionIfNull(attachmentService, "attachmentService");
        ValidationUtils.throwExceptionIfNull(attachmentRecognizer, "attachmentRecognizer");
        ValidationUtils.throwExceptionIfNull(preConditionChecker, "preConditionChecker");
        this.attachmentService = attachmentService;
        this.attachmentRecognizer = attachmentRecognizer;
        this.preConditionChecker = preConditionChecker;
        this.ticketReaderProvider = () -> TicketManager.getReaderForSystem();
        this.ticketManipulatorProvider = () -> TicketManager.getManipulator();
        this.actionProvider = actionID -> (ActionVO)ActionManager.getInstance().get(actionID.intValue());
    }

    protected void setActionAndTicketManipulatorProviders(Function<Integer, ActionVO> actionProvider, Supplier<TicketReaderBase> ticketReaderProvider, Supplier<TicketManipulator> ticketManipulatorProvider) {
        this.actionProvider = actionProvider;
        this.ticketReaderProvider = ticketReaderProvider;
        this.ticketManipulatorProvider = ticketManipulatorProvider;
    }

    @Override
    public AttachmentDescriptionList getAttachmentsForTicket(Integer ticketId, ContextType type) throws IllegalArgumentException {
        ValidationUtils.throwExceptionIfNullOrNegative(ticketId, "ticketId");
        AttachmentDescriptionList result = new AttachmentDescriptionList();
        ArrayList<Integer> bundledTicketIds = new ArrayList<Integer>();
        try {
            if (ContextType.supporter == type) {
                List ticketsInBundle = TicketManager.getReaderForSystem().getTicketsInBundle(ticketId.intValue(), true);
                bundledTicketIds.addAll(ticketsInBundle.stream().map(t -> t.getID()).collect(Collectors.toList()));
            }
            if (bundledTicketIds.isEmpty()) {
                bundledTicketIds.add(ticketId);
            }
            Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets = this.attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.TicketAttachment, bundledTicketIds);
            result.setAttachments(this.attachmentRecognizer.createFilterableAttachmentsFrom(fullAttachmentDataForTickets));
        }
        catch (Exception e) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)e);
        }
        return result;
    }

    @Override
    public AttachmentDescriptionList getAllTicketBundleAttachments(int ticketId) {
        ValidationUtils.throwExceptionIfNegative(ticketId, "ticketId");
        AttachmentDescriptionList result = new AttachmentDescriptionList();
        ArrayList<Integer> bundledTicketIds = new ArrayList<Integer>();
        try {
            bundledTicketIds.addAll(this.ticketDAO.getBundledTicketIdsMember(ticketId));
            Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets = this.attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.TicketAttachment, bundledTicketIds);
            result.setAttachments(this.attachmentRecognizer.createFilterableAttachmentsFrom(fullAttachmentDataForTickets));
        }
        catch (Exception e) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)e);
        }
        return result;
    }

    @Override
    public AttachmentDescription addFile(AttachmentDescription description, InputStream dataStream, AttachmentType type) throws IOException {
        ExternalImageAttachmentAdderImpl adder = new ExternalImageAttachmentAdderImpl(this.attachmentService, this);
        return adder.addFile(AttachmentOwnerType.TicketAttachment, description, dataStream, type);
    }

    public AttachmentService.Answer updateAttachmentData(Integer ticketId, Integer stepId, LargeContent data) throws IOException {
        ValidationUtils.throwExceptionIfNullOrNegative(ticketId, "ticketId");
        ValidationUtils.throwExceptionIfNull(stepId, "stepId");
        ValidationUtils.throwExceptionIfNull(data, "data");
        try {
            return this.attachmentService.updateAttachment(AttachmentOwnerType.TicketAttachment, ticketId, stepId, data);
        }
        catch (Exception ex) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)ex);
            throw new IOException(ex);
        }
    }

    @Override
    public void deleteAttachments(List<AttachmentDescription> toDelete) throws IOException {
        this.throwExceptionIfAttachmentServiceIsNotSet();
        this.throwExceptionIfTicketServiceIsNotSet();
        TicketAttachmentService.throwIfCurrentUserCannotDeleteAttachmentsInAtLeastOneOfTickets(toDelete);
        this.preConditionChecker.checkPreConditionsOfDeleteAttachmentsMethod(AttachmentOwnerType.TicketAttachment, toDelete);
        try {
            String allAttFileNames;
            ArrayList<String> listOfAttFileNames = new ArrayList<String>();
            HashSet<Integer> listOfAllStepsWhereAttachmentsWereRemoved = new HashSet<Integer>();
            for (AttachmentDescription description : toDelete) {
                this.attachmentService.deleteAttachment(AttachmentOwnerType.TicketAttachment, description.getOwnerId(), description.getStepId(), description.getFileName());
                listOfAttFileNames.add(description.getFileName());
                if (description.getStepId() <= -1) continue;
                listOfAllStepsWhereAttachmentsWereRemoved.add(description.getStepId());
            }
            int ticketID = toDelete.get(0).getOwnerId();
            String stepDesc = allAttFileNames = listOfAttFileNames.stream().collect(Collectors.joining(", "));
            ReaStepTextVO stepText = ReaStepTextVO.empty();
            int maxDescLength = 255;
            if (stepDesc.length() > maxDescLength) {
                stepDesc = StringConcatenator.concatAndShortenIfNeeded(listOfAttFileNames, (int)maxDescLength);
                stepText = ReaStepTextVO.of((String)allAttFileNames, (boolean)false);
            }
            MutableReaStepData stepData = new MutableReaStepData();
            stepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)stepDesc);
            ActionVO action = this.actionProvider.apply(-6);
            ExtensionArguments args = ExtensionArguments.create();
            args.put(DeleteAttachmentExtension.ARG_CHANGED_REASTEPS, listOfAllStepsWhereAttachmentsWereRemoved);
            this.ticketManipulatorProvider.get().applyAction(ticketID, stepData, stepText, action, args);
        }
        catch (Exception ex) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)ex);
            throw new IOException(ex);
        }
    }

    public AttachmentDescription[] addAttachments(int ticketId, int stepId, LargeContent[] attachments) throws IOException {
        this.throwExceptionIfAttachmentServiceIsNotSet();
        this.throwExceptionIfTicketServiceIsNotSet();
        this.preConditionChecker.checkPreConditionsOfAddAttachmentsMethod(ticketId, stepId, attachments);
        try {
            if (stepId == -1) {
                stepId = TicketManager.getReaderForSystem().getTicket(ticketId).getInitialReaStepID();
            }
        }
        catch (Exception ex) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)ex);
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
        return new AddAttachmentsServiceMethod().addAttachments(this.attachmentService, AttachmentOwnerType.TicketAttachment, ticketId, stepId, attachments);
    }

    private static void throwIfCurrentUserCannotDeleteAttachmentsInAtLeastOneOfTickets(List<AttachmentDescription> toDelete) {
        List owners = toDelete.stream().map(AttachmentDescription::getOwnerId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        for (Integer ownerId : owners) {
            ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(-6);
            ActionCheckError checkAction = TicketManager.getTicketActionChecker().checkAction(actionVO, ownerId.intValue());
            if (checkAction == null) continue;
            throw HDErrors.createExceptionForCode((ActionCheckError)checkAction);
        }
    }

    private void throwExceptionIfAttachmentServiceIsNotSet() {
        if (this.attachmentService == null) {
            throw new IllegalStateException("attachment service which is TicketAttachmentService's mandatory dependency must not be null");
        }
    }

    private void throwExceptionIfTicketServiceIsNotSet() {
    }

    public void setTicketDAO(TicketDAO ticketDAO) {
        this.ticketDAO = ticketDAO;
    }
}

