/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.plugins.attachments.server.AddAttachmentsServiceMethod;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.PreConditionCheckerForAttachmentServices;
import com.inet.helpdesk.plugins.attachments.server.TicketAttachmentService;
import com.inet.helpdesk.plugins.attachments.server.mail.ImageReferenceReplacer;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.shared.http.upload.AttachmentType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class ExternalImageAttachmentAdderImpl
implements ExternalImageAttachmentAdder {
    private final PreConditionCheckerForAttachmentServices preConditionChecker = new PreConditionCheckerForAttachmentServices();
    private final AttachmentService attachmentService;
    private final TicketAttachmentService ticketAttachmentService;
    public static int DATA_IMAGE_MAX_SIZE = 512000;

    public ExternalImageAttachmentAdderImpl(@Nonnull AttachmentService attachmentService, @Nonnull TicketAttachmentService ticketAttachmentService) {
        this.attachmentService = attachmentService;
        this.ticketAttachmentService = ticketAttachmentService;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "URLCONNECTION_SSRF_FD"}, justification="Reading user specified file (external attachment), limited to http, is expected")
    public String convertExternalImagesToAttachments(AttachmentOwnerType type, int ownerId, int stepId, String stepContent) {
        if (stepContent == null || stepContent.length() == 0) {
            return null;
        }
        AtomicBoolean attachmentsAdded = new AtomicBoolean(false);
        AtomicInteger connectionTimeout = new AtomicInteger(10000);
        HashMap replacedAttachments = new HashMap();
        stepContent = ImageReferenceReplacer.genericReplaceImageSources(stepContent, src -> {
            String lowercasedSrc = src.toLowerCase();
            if (lowercasedSrc.startsWith("attachments/")) {
                if (this.isAttachmentForThisStep(type, ownerId, stepId, lowercasedSrc)) {
                    return src;
                }
                if (replacedAttachments.containsKey(lowercasedSrc)) {
                    return ((AttachmentDescription)replacedAttachments.get(lowercasedSrc)).getRESTfulFilePath();
                }
                try {
                    AttachmentDescription description = this.addOtherAttachment(type, ownerId, stepId, (String)src);
                    if (description == null) {
                        AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment not found: " + src));
                        return src;
                    }
                    attachmentsAdded.set(true);
                    replacedAttachments.put(lowercasedSrc, description);
                    return description.getRESTfulFilePath();
                }
                catch (Throwable ex) {
                    AttachmentsServerPlugin.LOGGER.warn((Object)("Cannot load attachment: " + src));
                    AttachmentsServerPlugin.LOGGER.warn((Object)ex);
                }
            }
            return src;
        });
        stepContent = ImageReferenceReplacer.genericReplaceImageSourcesInImagesOnly(stepContent, src -> {
            String lowercasedSrc = src.toLowerCase();
            if (lowercasedSrc.startsWith("http://") || lowercasedSrc.startsWith("https://")) {
                InputStream inputStream = null;
                try {
                    URL url = new URL(StringFunctions.decodeHTML((String)src));
                    URLConnection connection = url.openConnection();
                    connection.setConnectTimeout(connectionTimeout.intValue());
                    connection.setReadTimeout(10000);
                    inputStream = connection.getInputStream();
                    AttachmentDescription desc = new AttachmentDescription();
                    desc.setFileName(this.orDummyFileName(new File(url.getPath()).getName()));
                    desc.setLastModified(connection.getLastModified() > 0L ? connection.getLastModified() : System.currentTimeMillis());
                    desc.setOwnerId(ownerId);
                    desc.setStepId(stepId);
                    desc = this.addFile(type, desc, inputStream, AttachmentType.EmbeddedImage);
                    attachmentsAdded.set(true);
                    String string = desc.getRESTfulFilePath();
                    return string;
                }
                catch (Throwable exc) {
                    if (exc instanceof ConnectException || exc instanceof SocketTimeoutException) {
                        connectionTimeout.set(Math.max(1000, connectionTimeout.intValue() / 2));
                    }
                    AttachmentsServerPlugin.LOGGER.warn((Object)("Cannot load attachment: " + src));
                    AttachmentsServerPlugin.LOGGER.warn((Object)exc);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (lowercasedSrc.startsWith("data:image/") && lowercasedSrc.length() > DATA_IMAGE_MAX_SIZE) {
                try {
                    byte[] data = lowercasedSrc.contains(";base64,") ? Base64.getDecoder().decode(src.substring(src.indexOf(";base64,") + 8)) : src.substring(src.indexOf(44)).getBytes(StandardCharsets.UTF_8);
                    int index = src.indexOf(59);
                    if (index == -1) {
                        index = src.indexOf(44);
                    }
                    String extension = src.substring(src.indexOf(47) + 1, index);
                    AttachmentDescription desc = new AttachmentDescription();
                    desc.setFileName("image." + extension);
                    desc.setLastModified(System.currentTimeMillis());
                    desc.setOwnerId(ownerId);
                    desc.setStepId(stepId);
                    desc = this.addFile(type, desc, new ByteArrayInputStream(data), AttachmentType.EmbeddedImage);
                    attachmentsAdded.set(true);
                    return desc.getRESTfulFilePath();
                }
                catch (IOException | IllegalArgumentException exc) {
                    AttachmentsServerPlugin.LOGGER.warn((Object)("Cannot convert attachment: " + src));
                    AttachmentsServerPlugin.LOGGER.warn((Object)exc);
                }
            }
            return src;
        });
        return attachmentsAdded.get() ? stepContent : null;
    }

    @Override
    public Set<String> findNamesOfReferencedAttachments(AttachmentOwnerType type, int ownerId, int stepId, String stepContent) {
        if (stepContent == null || stepContent.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        int tagIndex = -1;
        while ((tagIndex = stepContent.indexOf("<img", tagIndex + 1)) != -1) {
            String lowerCasedPrefix;
            String attName;
            String src;
            String lowercasedSrc;
            int tagEndIndex = stepContent.indexOf(">", tagIndex);
            int srcIndex = stepContent.indexOf("src=\"", tagIndex);
            int srcEndIndex = stepContent.indexOf("\"", srcIndex + 5);
            if (srcIndex <= tagIndex || srcIndex >= tagEndIndex || srcIndex >= srcEndIndex || srcEndIndex >= tagEndIndex || !(lowercasedSrc = (src = stepContent.substring(srcIndex + 5, srcEndIndex)).toLowerCase()).startsWith("attachments/") || !this.isAttachmentForThisStep(type, ownerId, stepId, lowercasedSrc) || (attName = src.substring((lowerCasedPrefix = this.getLowerCasedPrefixFor(type, ownerId, stepId)).length())).trim().isEmpty()) continue;
            result.add(attName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentDescription addOtherAttachment(AttachmentOwnerType targetType, int ownerId, int stepId, String attachmentRestfulPath) throws IOException {
        AttachmentDescription attachmentDescription;
        ValidationUtils.throwExceptionIfNegative(ownerId, "ownerId");
        ValidationUtils.throwExceptionIfNull(attachmentRestfulPath, "attachmentRestfulPath");
        attachmentRestfulPath = StringFunctions.decodeHTML((String)attachmentRestfulPath);
        String attachmentRestfulPathFinal = attachmentRestfulPath = EncodingFunctions.decodeUrlPath((String)attachmentRestfulPath);
        boolean isValidPath = AttachmentOwnerType.values().stream().anyMatch(type -> AttachmentFilePathBuilder.isRestfulPathOfGivenAttachmentType(attachmentRestfulPathFinal, type));
        if (!isValidPath) {
            return null;
        }
        AttachmentKey key = AttachmentFilePathBuilder.convertRestfulPathToKey(attachmentRestfulPath);
        final File tempFile = this.attachmentService.createTempCopyOfAttachmentFile(key);
        try {
            LargeContent data = new LargeContent(new LargeContent.InputStreamProvider(){

                public long getSize() {
                    return tempFile.length();
                }

                public InputStream getStream() {
                    try {
                        return new FileInputStream(tempFile);
                    }
                    catch (FileNotFoundException e) {
                        AttachmentsServerPlugin.LOGGER.error((Throwable)e);
                        return null;
                    }
                }
            });
            data.setLastModified(tempFile.lastModified());
            data.setContentType(AttachmentType.EmbeddedImage);
            data.setName(key.getFileName());
            attachmentDescription = this.addAttachment(targetType, ownerId, stepId, data);
            tempFile.delete();
        }
        catch (Throwable throwable) {
            try {
                tempFile.delete();
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                throw new IOException("Attachment file denoted by following restful path could not be found: " + attachmentRestfulPath);
            }
        }
        return attachmentDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentDescription addFile(AttachmentOwnerType targetAttType, AttachmentDescription description, InputStream dataStream, AttachmentType contentType) throws IOException {
        AttachmentDescription attachmentDescription;
        ValidationUtils.throwExceptionIfNull(description, "description");
        ValidationUtils.throwExceptionIfNull(dataStream, "dataStream");
        ValidationUtils.throwExceptionIfNullOrEmptyAfterTrim(description.getFileName(), "fileName");
        ValidationUtils.throwExceptionIfNullOrNegative(description.getOwnerId(), "ownerId");
        if (description.getLastModified() <= 0L) {
            throw new IllegalArgumentException("lastModified must be greater than 0");
        }
        final File tempFile = File.createTempFile("hd_attachment", null);
        try {
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                IOFunctions.copyData((InputStream)dataStream, (OutputStream)out);
            }
            LargeContent data = new LargeContent(new LargeContent.InputStreamProvider(){

                public long getSize() {
                    return tempFile.length();
                }

                public InputStream getStream() {
                    try {
                        return new FileInputStream(tempFile);
                    }
                    catch (FileNotFoundException e) {
                        AttachmentsServerPlugin.LOGGER.error((Throwable)e);
                        return null;
                    }
                }
            });
            data.setLastModified(description.getLastModified());
            data.setContentType(contentType);
            data.setName(description.getFileName());
            int ownerId = description.getOwnerId();
            int stepId = description.getStepId();
            attachmentDescription = this.addAttachment(targetAttType, ownerId, stepId, data);
            tempFile.delete();
        }
        catch (Throwable throwable) {
            try {
                tempFile.delete();
                throw throwable;
            }
            catch (Exception ex) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)ex);
                throw ex;
            }
        }
        return attachmentDescription;
    }

    @Override
    public AttachmentDescription addAttachment(AttachmentOwnerType targetType, int targetOwnerId, int targetStepId, LargeContent attachment) throws IOException {
        LargeContent[] attachments = new LargeContent[]{attachment};
        if (AttachmentOwnerType.TicketAttachment.equals(targetType)) {
            return this.ticketAttachmentService.addAttachments(targetOwnerId, targetStepId, attachments)[0];
        }
        this.preConditionChecker.checkPreConditionsOfAddAttachmentsMethod(targetOwnerId, targetStepId, attachments);
        return new AddAttachmentsServiceMethod().addAttachments(this.attachmentService, targetType, targetOwnerId, targetStepId, attachments)[0];
    }

    private String orDummyFileName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return "image";
        }
        return name;
    }

    private boolean isAttachmentForThisStep(AttachmentOwnerType type, int ownerId, int stepId, String lowercasedSrc) {
        String lowerCasedPrefix = this.getLowerCasedPrefixFor(type, ownerId, stepId);
        if (stepId == -1) {
            return lowercasedSrc.startsWith(lowerCasedPrefix) && lowercasedSrc.substring(lowerCasedPrefix.length()).indexOf(47) == -1;
        }
        return lowercasedSrc.startsWith(lowerCasedPrefix);
    }

    private String getLowerCasedPrefixFor(AttachmentOwnerType type, int ownerId, int stepId) {
        String lowerCasedAttSubContext = type.getAttachmentSubContext().toLowerCase();
        if (stepId == -1) {
            return "attachments/" + lowerCasedAttSubContext + "/" + ownerId + "/";
        }
        return "attachments/" + lowerCasedAttSubContext + "/" + ownerId + "/" + stepId + "/";
    }
}

