/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DirectoryTreeManager {
    private static int limitOfNodes = 1000;
    private static int limitOfFiles = 1000;
    private static final Map<String, DirectoryTreeManager> managers = new HashMap<String, DirectoryTreeManager>();
    private String dirName;
    private int currentBranchId;
    private int currentNodeId;

    private DirectoryTreeManager(String dirName) {
        this.dirName = dirName;
    }

    public PersistenceEntry getRootDirectory() {
        return DirectoryTreeManager.getRootDirectory(this.dirName);
    }

    static PersistenceEntry getRootDirectory(String directoryName) {
        return Persistence.getInstance().resolve(directoryName);
    }

    public static DirectoryTreeManager getManager(String dirName) {
        if (!managers.containsKey(dirName)) {
            DirectoryTreeManager dirManager = new DirectoryTreeManager(dirName);
            dirManager.setCurrentBranchAndNodeIds();
            managers.put(dirName, dirManager);
        }
        return managers.get(dirName);
    }

    private void setCurrentBranchAndNodeIds() {
        PersistenceEntry rootDirectory = this.getRootDirectory();
        this.currentBranchId = this.findCurrentBranch(rootDirectory);
        this.currentNodeId = this.findCurrentNode(rootDirectory, this.currentBranchId);
    }

    private int findCurrentBranch(PersistenceEntry rootDirectory) {
        int branchId = this.getCurrentIdInside(rootDirectory);
        PersistenceEntry branch = this.getBranch(rootDirectory, branchId);
        if (this.exceedsLimitOfNodesIfExists(branch)) {
            ++branchId;
        }
        return branchId;
    }

    private int findCurrentNode(PersistenceEntry rootDirectory, int branchId) {
        PersistenceEntry branch = this.getBranch(rootDirectory, branchId);
        if (branch.exists()) {
            return this.getCurrentIdInside(branch);
        }
        return 0;
    }

    private boolean exceedsLimitOfNodesIfExists(PersistenceEntry branch) {
        if (!branch.exists()) {
            return false;
        }
        return this.getNumberOfFilesInside(branch) > limitOfNodes;
    }

    public PersistenceEntry getDirectoryWhichIsNotFull() throws IOException {
        PersistenceEntry branch = this.getBranch(this.currentBranchId);
        PersistenceEntry node = this.getNode(branch, this.currentNodeId);
        if (!branch.exists()) {
            return node;
        }
        boolean nodeExists = node.exists();
        boolean branchCanContainMoreNodes = this.canBranchContainMoreNodes(branch);
        if (nodeExists) {
            if (this.canNodeContainMoreFiles(node)) {
                return node;
            }
            if (branchCanContainMoreNodes) {
                return this.getNextNodeInsideBranch(branch);
            }
            return this.getInitialNodeInsideNextBranch();
        }
        if (branchCanContainMoreNodes) {
            return node;
        }
        return this.getInitialNodeInsideNextBranch();
    }

    private boolean canBranchContainMoreNodes(PersistenceEntry branch) {
        return this.getNumberOfFilesInside(branch) < limitOfNodes;
    }

    private boolean canNodeContainMoreFiles(PersistenceEntry node) {
        return this.getNumberOfFilesInside(node) < limitOfFiles;
    }

    private PersistenceEntry getNextNodeInsideBranch(PersistenceEntry branch) {
        int nextNodeId = this.getIdForNextNode(branch);
        PersistenceEntry nextNode = this.getNode(branch, nextNodeId);
        this.currentNodeId = nextNodeId;
        return nextNode;
    }

    private PersistenceEntry getInitialNodeInsideNextBranch() {
        int nextBranchId = this.getIdForNextBranch();
        PersistenceEntry nextBranchPath = this.getBranch(nextBranchId);
        PersistenceEntry initialNodePath = this.getNode(nextBranchPath, 0);
        this.currentBranchId = nextBranchId;
        this.currentNodeId = 0;
        return initialNodePath;
    }

    private int getIdForNextBranch() {
        PersistenceEntry nextBranch;
        int nextBranchId = this.currentBranchId + 1;
        while ((nextBranch = this.getBranch(nextBranchId)).exists()) {
            ++nextBranchId;
        }
        return nextBranchId;
    }

    private int getIdForNextNode(PersistenceEntry branch) {
        PersistenceEntry nextNodePath;
        int nextNodeId = this.currentNodeId + 1;
        while ((nextNodePath = this.getNode(branch, nextNodeId)).exists()) {
            ++nextNodeId;
        }
        return nextNodeId;
    }

    private int getNumberOfFilesInside(PersistenceEntry dir) {
        return dir.getChildren().size();
    }

    private PersistenceEntry getBranch(int branchId) {
        return this.getBranch(this.getRootDirectory(), branchId);
    }

    private PersistenceEntry getBranch(PersistenceEntry rootDirectory, int branchId) {
        return rootDirectory.resolve(String.valueOf(branchId));
    }

    private PersistenceEntry getNode(PersistenceEntry branch, int nodeId) {
        return branch.resolve(String.valueOf(nodeId));
    }

    private int getCurrentIdInside(PersistenceEntry directory) {
        int currentId = 0;
        for (PersistenceEntry file : directory.getChildren()) {
            if (!DirectoryTreeManager.isBranchOrNodeDirectory(file)) continue;
            currentId = Math.max(currentId, Integer.parseInt(file.getName()));
        }
        return currentId;
    }

    public static boolean isBranchOrNodeDirectory(PersistenceEntry resource) {
        try {
            String dirName = resource.getName();
            int dirNameAsInt = Integer.parseInt(dirName);
            return dirName.equals(String.valueOf(dirNameAsInt));
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected static void setNullAsInstance(String dirName) {
        managers.remove(dirName);
    }

    protected static void setNodeLimit(int limit) throws IllegalArgumentException {
        if (limitOfNodes <= 0) {
            throw new IllegalArgumentException("limit of nodes inside each directory branch must be greater than zero");
        }
        limitOfNodes = limit;
    }

    protected static void setFileLimit(int limit) throws IllegalArgumentException {
        if (limitOfFiles <= 0) {
            throw new IllegalArgumentException("limit of files inside each node must be greater than zero");
        }
        limitOfFiles = limit;
    }
}

