/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.data.TempDirectory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.http.PluginServlet;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.PersistenceEntry;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class AttachmentServlet
extends HttpServlet
implements PluginServlet {
    public static final String CONTEXT = "/Attachments";
    private AttachmentDAO attachmentDAO;

    public String getPathSpec() {
        return CONTEXT;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AttachmentKey key;
        if (UserManager.getInstance().getCurrentUserAccountID() == null) {
            throw new AccessDeniedException();
        }
        try {
            key = AttachmentFilePathBuilder.convertRestfulPathToKey(request.getPathInfo());
        }
        catch (IllegalArgumentException ex) {
            if (!this.sendTempAttachmentFile(request, response)) {
                AttachmentsServerPlugin.LOGGER.warn((Object)ex);
                ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
            }
            return;
        }
        key.getType().checkPermission(UserManager.getInstance().getCurrentUserAccount(), key);
        AttachmentFileRow attachmentFileRow = null;
        try {
            attachmentFileRow = this.attachmentDAO.getAttachmentFile(key);
        }
        catch (SQLException e) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATABASE_ERROR));
            throw new IOException(e);
        }
        if (attachmentFileRow == null) {
            AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment not found for path " + request.getPathInfo()));
            ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String realFilePath = attachmentFileRow.getFilePath();
        PersistenceEntry file = AppDataLocation.getAttachmentFile((String)realFilePath);
        if (!file.exists()) {
            AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment not found for path " + request.getPathInfo()));
            ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String zipEntry = request.getParameter("zipentry");
        if (!StringFunctions.isEmpty((String)zipEntry) && "application/zip".equals(MimeTypes.getMimeType((String)key.getFileName()))) {
            try (ZipInputStream zipStream = new ZipInputStream(file.getInputStream(), Charset.forName("CP437"));){
                ZipEntry entry = null;
                while ((entry = zipStream.getNextEntry()) != null) {
                    if (!zipEntry.equals(entry.getName())) continue;
                    String fileName = entry.getName();
                    int index = fileName.lastIndexOf(47);
                    if (index >= 0) {
                        fileName = fileName.substring(index + 1);
                    }
                    if (request.getParameter("download") != null) {
                        ServletUtils.setContentDisposition((HttpServletResponse)response, (String)fileName, (boolean)false);
                    }
                    String mimeType = MimeTypes.getMimeType((String)fileName);
                    ServletUtils.sendStaticContent((String)mimeType, (long)entry.getTime(), (long)((int)entry.getSize()), (InputStream)zipStream, (HttpServletRequest)request, (HttpServletResponse)response);
                    return;
                }
            }
            AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment not found for path " + request.getPathInfo() + " and entry " + zipEntry));
            ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String fileName = key.getFileName();
        if (request.getParameter("download") != null) {
            ServletUtils.setContentDisposition((HttpServletResponse)response, (String)fileName, (boolean)false);
        }
        String mimeType = MimeTypes.getMimeType((String)fileName);
        try (InputStream input = file.getInputStream();){
            ServletUtils.sendStaticContent((String)mimeType, (long)file.lastModified(), (long)((int)attachmentFileRow.getFileLength()), (InputStream)input, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (FileNotFoundException ex) {
            AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment not found for path " + request.getPathInfo()));
            ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
    }

    private boolean sendTempAttachmentFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String tempMimeAttDirPrefix;
        String ticketTypePrefix;
        String pathInfo = request.getPathInfo();
        if (pathInfo.startsWith(ticketTypePrefix = "/" + AttachmentOwnerType.TicketAttachment.getAttachmentSubContext())) {
            pathInfo = pathInfo.substring(ticketTypePrefix.length());
        }
        if (!pathInfo.startsWith(tempMimeAttDirPrefix = "/Attachments_Temp")) {
            return false;
        }
        if ((pathInfo = pathInfo.substring(tempMimeAttDirPrefix.length())).startsWith(File.separator) || pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        File file = TempDirectory.ATTACHMENTS_TEMP.resolve(pathInfo).toFile();
        File attachmentTempDir = TempDirectory.ATTACHMENTS_TEMP.toFile().getCanonicalFile();
        if (!file.getCanonicalFile().toPath().startsWith(attachmentTempDir.toPath())) {
            return false;
        }
        if (file.exists()) {
            ServletUtils.sendStaticContent((File)file, (HttpServletRequest)request, (HttpServletResponse)response);
            return true;
        }
        return false;
    }
}

