/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationRetryException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentFileService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ChecksumUtils;
import com.inet.helpdesk.plugins.attachments.server.MessageMim;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.MimeMessageContent;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.persistence.PersistenceEntry;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

public class AttachmentService {
    private AttachmentDAO attachmentDAO;
    private AttachmentFileService attFileService;

    public void setDependencies(AttachmentDAO attachmentDAO, AttachmentFileService attFileService) {
        this.attachmentDAO = attachmentDAO;
        this.attFileService = attFileService;
    }

    public synchronized Answer createAttachment(AttachmentOwnerType type, int ownerId, int stepId, String uniqueDisplayName, LargeContent data) throws IOException {
        try {
            InputStream inputStream = data.getStreamProvider().getStream();
            if (inputStream == null) {
                throw new FileNotFoundException(data.getName());
            }
            String checksum = ChecksumUtils.computeChecksum(inputStream);
            long fileLength = data.getSize();
            PersistenceEntry destFile = null;
            AttachmentFileRow attachmentFileRow = this.attachmentDAO.getAttachmentFile(checksum, fileLength);
            if (attachmentFileRow == null) {
                String targetFileName = AttachmentFileRow.getFileName(checksum, fileLength);
                destFile = this.attFileService.createAttachmentFile(data.getStreamProvider().getStream(), targetFileName);
                String parentDirPath = AttachmentFileService.getParentDirPathWhichIsRelativeToAttachmentDir(destFile);
                AttachmentFileRow newAttachmentFileRow = new AttachmentFileRow(checksum, parentDirPath, fileLength);
                this.attachmentDAO.createAttachmentFile(newAttachmentFileRow);
            } else {
                destFile = this.attFileService.getAttachmentFile(attachmentFileRow.getFilePath());
                destFile = this.recreateFileIfDoesNotExist(destFile, data.getStreamProvider().getStream(), checksum, fileLength);
            }
            int additionalId = -1;
            AttachmentKey key = new AttachmentKey(type, ownerId, stepId, additionalId, uniqueDisplayName);
            long attachmentLastModified = System.currentTimeMillis();
            AttachmentRow newAttachmentRow = new AttachmentRow(key, checksum, fileLength, AttachmentService.isEmbeddedAttachment(data), attachmentLastModified);
            this.attachmentDAO.createAttachment(newAttachmentRow);
            if (AttachmentOwnerType.TicketAttachment.equals(type)) {
                AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(ownerId, Collections.emptyList(), Collections.singletonList(newAttachmentRow.getFileName()));
            }
            return new Answer(destFile, attachmentLastModified, true);
        }
        catch (SQLException sqle) {
            if (sqle instanceof SQLTransientException) {
                throw new TicketOperationRetryException((Throwable)sqle);
            }
            throw new IOException(sqle);
        }
    }

    public synchronized Answer updateAttachment(AttachmentOwnerType type, int ownerId, int stepId, LargeContent data) throws IOException {
        String checksum = ChecksumUtils.computeChecksum(data.getStreamProvider().getStream());
        return this.updateAttachment(type, ownerId, stepId, data.getStreamProvider().getStream(), data.getName(), data.getSize(), checksum, AttachmentService.isEmbeddedAttachment(data));
    }

    private synchronized Answer updateAttachment(AttachmentOwnerType type, int ownerId, int stepId, InputStream tempFileStream, String displayName, long fileLength, String checksum, boolean isEmbedded) throws IOException {
        PersistenceEntry destFile = null;
        try {
            long attachmentLastModified;
            boolean doesAttachmentFileRowExist;
            int additionalId = -1;
            AttachmentKey key = new AttachmentKey(type, ownerId, stepId, additionalId, displayName);
            AttachmentRow attachmentRow = this.attachmentDAO.getAttachment(key);
            boolean doesAttachmentRowExist = attachmentRow != null;
            AttachmentFileRow attachmentFileRow = this.attachmentDAO.getAttachmentFile(checksum, fileLength);
            boolean bl = doesAttachmentFileRowExist = attachmentFileRow != null;
            if (!doesAttachmentFileRowExist) {
                String targetFileName = AttachmentFileRow.getFileName(checksum, fileLength);
                destFile = this.attFileService.createAttachmentFile(tempFileStream, targetFileName);
                String parentDirPath = AttachmentFileService.getParentDirPathWhichIsRelativeToAttachmentDir(destFile);
                attachmentFileRow = new AttachmentFileRow(checksum, parentDirPath, fileLength);
                this.attachmentDAO.createAttachmentFile(attachmentFileRow);
            } else {
                destFile = this.attFileService.getAttachmentFile(attachmentFileRow.getFilePath());
                destFile = this.recreateFileIfDoesNotExist(destFile, tempFileStream, checksum, fileLength);
            }
            boolean newAttachmentCreated = false;
            if (doesAttachmentRowExist) {
                String currentFileChecksum = attachmentRow.getChecksum();
                long currentFileLength = attachmentRow.getFileLength();
                attachmentLastModified = System.currentTimeMillis();
                this.attachmentDAO.updateAttachment(key, checksum, fileLength, attachmentLastModified);
                int numberOfAttachmentsForCurrentFile = this.attachmentDAO.getNumberOfAttachmentsForFile(currentFileChecksum, currentFileLength);
                if (numberOfAttachmentsForCurrentFile == 0) {
                    AttachmentFileRow currentAttachmentFile = this.attachmentDAO.getAttachmentFile(currentFileChecksum, currentFileLength);
                    this.attachmentDAO.removeAttachmentFile(currentFileChecksum, currentFileLength);
                    this.attFileService.deleteFile(currentAttachmentFile.getFilePath());
                }
            } else {
                attachmentLastModified = System.currentTimeMillis();
                AttachmentRow newAttachmentRow = new AttachmentRow(key, checksum, fileLength, isEmbedded, attachmentLastModified);
                this.attachmentDAO.createAttachment(newAttachmentRow);
                newAttachmentCreated = true;
            }
            if (AttachmentOwnerType.TicketAttachment.equals(type) && !doesAttachmentRowExist) {
                AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(ownerId, Collections.emptyList(), Collections.singletonList(key.getFileName()));
            }
            return new Answer(destFile, attachmentLastModified, newAttachmentCreated);
        }
        catch (SQLException sqle) {
            if (sqle instanceof SQLTransientException) {
                throw new TicketOperationRetryException((Throwable)sqle);
            }
            throw new IOException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceEntry recreateFileIfDoesNotExist(PersistenceEntry destFile, InputStream sourceStream, String checksum, long fileLength) throws IOException, SQLException {
        try {
            if (destFile.exists()) {
                PersistenceEntry persistenceEntry = destFile;
                return persistenceEntry;
            }
            String targetFileName = AttachmentFileRow.getFileName(checksum, fileLength);
            PersistenceEntry recreatedAttFile = this.attFileService.createAttachmentFile(sourceStream, targetFileName);
            String parentDirPath = AttachmentFileService.getParentDirPathWhichIsRelativeToAttachmentDir(recreatedAttFile);
            this.attachmentDAO.updateAttachmentFilePath(checksum, fileLength, parentDirPath);
            PersistenceEntry persistenceEntry = recreatedAttFile;
            return persistenceEntry;
        }
        finally {
            sourceStream.close();
        }
    }

    public synchronized void deleteAttachment(AttachmentOwnerType type, int ownerId, int stepId, String fileName) throws IOException {
        try {
            long fileLength;
            String crc;
            int numberOfAttachmentsForFile;
            int additionalId = -1;
            AttachmentKey key = new AttachmentKey(type, ownerId, stepId, additionalId, fileName);
            AttachmentFileRow attachmentFileRow = this.attachmentDAO.getAttachmentFile(key);
            if (attachmentFileRow == null) {
                AttachmentsServerPlugin.LOGGER.warn((Object)("There is no attachment file row for given attachment description where ownerId=" + ownerId + " stepId=" + stepId + " fileName=" + fileName + " type=" + type.toString()));
                return;
            }
            List<String> attachmentNamesBefore = Collections.emptyList();
            if (AttachmentOwnerType.TicketAttachment.equals(type)) {
                attachmentNamesBefore = this.attachmentDAO.getFileNamesFromAttachments(AttachmentOwnerType.TicketAttachment, ownerId);
            }
            this.attachmentDAO.removeAttachment(key);
            if (AttachmentOwnerType.TicketAttachment.equals(type)) {
                ArrayList<String> attachmentNamesAfter = new ArrayList<String>(attachmentNamesBefore);
                attachmentNamesAfter.remove(fileName);
                AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(ownerId, attachmentNamesBefore, attachmentNamesAfter);
            }
            if ((numberOfAttachmentsForFile = this.attachmentDAO.getNumberOfAttachmentsForFile(crc = attachmentFileRow.getChecksum(), fileLength = attachmentFileRow.getFileLength())) == 0) {
                this.attachmentDAO.removeAttachmentFile(crc, fileLength);
                this.attFileService.deleteFile(attachmentFileRow.getFilePath());
            }
        }
        catch (SQLException sqle) {
            if (sqle instanceof SQLTransientException) {
                throw new TicketOperationRetryException((Throwable)sqle);
            }
            throw new IOException(sqle);
        }
    }

    public MimeMessageContent getMimeMessageData(AttachmentOwnerType type, int ownerId, int stepId, String fileName, Integer sessionId) throws IOException {
        try {
            MimeMessage msg = this.getMessageFile(type, ownerId, stepId, fileName);
            MessageMim mim = new MessageMim(msg, sessionId.toString(), AttachmentsServerPlugin.LOGGER);
            MimeMessageContent result = mim.getResult();
            if (result.getAttachmentList() != null) {
                for (AttachmentDescription internalAttchment : result.getAttachmentList()) {
                    internalAttchment.setOwnerId(ownerId);
                    internalAttchment.setStepId(-1);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private MimeMessage getMessageFile(AttachmentOwnerType type, int ownerId, int stepId, String fileName) throws IllegalArgumentException, IOException, MessagingException, SQLException {
        AttachmentKey key = new AttachmentKey(type, ownerId, stepId, -1, fileName);
        AttachmentFileRow attachmentFileRow = this.attachmentDAO.getAttachmentFile(key);
        PersistenceEntry file = this.attFileService.getAttachmentFile(attachmentFileRow.getFilePath());
        if (file != null && file.exists()) {
            try (InputStream is = file.getInputStream();){
                MimeMessage mimeMessage = new MimeMessage(null, is);
                return mimeMessage;
            }
        }
        throw new IllegalArgumentException("File could not be located using id:" + ownerId + ", stepid:" + stepId + ", name:" + fileName);
    }

    public static boolean isEmbeddedAttachment(LargeContent data) {
        return data.getContentType() == AttachmentType.EmbeddedImage;
    }

    public static AttachmentDescription createDescriptionFrom(AttachmentRow row, AttachmentFileRow fileRow) {
        AttachmentDescription desc = new AttachmentDescription();
        desc.setPrefixedNameWithExtension(AttachmentFilePathBuilder.getOldAttachmentFileName(row.getOwnerId(), row.getStepId(), row.getFileName()));
        desc.setFilesize(row.getFileLength());
        desc.setFilePath(AttachmentFilePathBuilder.getOldAttachmentFilePath(row.getOwnerId(), row.getStepId(), row.getFileName()));
        desc.setLastModified(row.getLastModified());
        desc.setAttachmentType(row.getType());
        return desc;
    }

    public Map<AttachmentRow, AttachmentFileRow> getFullAttachmentDataFor(AttachmentOwnerType type, List<Integer> ownerIds) throws SQLException {
        return this.attachmentDAO.getFullAttachmentDataForOwner(type, ownerIds, true);
    }

    public AttachmentRow getAttachment(AttachmentKey key) throws SQLException {
        return this.attachmentDAO.getAttachment(key);
    }

    public AttachmentFileRow getAttachmentFile(String checksum, long fileLength) throws SQLException {
        return this.attachmentDAO.getAttachmentFile(checksum, fileLength);
    }

    public List<String> getFileNamesFromAttachments(AttachmentOwnerType type, int ownerId, int stepId) throws SQLException {
        return this.attachmentDAO.getFileNamesFromAttachments(type, ownerId, stepId);
    }

    public int getNumberOfAttachments(AttachmentOwnerType type, int id, boolean includeEmbedded) throws SQLException {
        return this.attachmentDAO.countAttachments(type, id, includeEmbedded);
    }

    public int getNumberOfAttachments(AttachmentOwnerType type, List<Integer> ownerIds, boolean includeEmbedded) throws SQLException {
        return this.attachmentDAO.countAttachments(type, ownerIds, includeEmbedded);
    }

    public boolean checkIsUnchangedOnServer(AttachmentOwnerType type, Integer ownerId, Integer stepId, String fileName, long fileLength, long lastModified) throws SQLException {
        AttachmentKey attachmentKey = new AttachmentKey(type, ownerId, stepId, -1, fileName);
        AttachmentRow attachmentRow = this.getAttachment(attachmentKey);
        if (attachmentRow != null) {
            if (attachmentRow.getFileLength() != fileLength) {
                return false;
            }
            if (attachmentRow.getLastModified() == lastModified) {
                return true;
            }
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="false-positive spotbugs-warning: no file creation")
    public File createTempCopyOfAttachmentFile(AttachmentKey key) throws IOException {
        try {
            key.getType().checkPermission(UserManager.getInstance().getCurrentUserAccount(), key);
            AttachmentFileRow attachmentFileRow = this.attachmentDAO.getAttachmentFile(key);
            if (attachmentFileRow == null) {
                throw new FileNotFoundException(key.toString());
            }
            PersistenceEntry attFile = this.attFileService.getAttachmentFile(attachmentFileRow.getFilePath());
            Path tempFilePath = Files.createTempFile(attFile.getName(), "", new FileAttribute[0]);
            try (InputStream in = attFile.getInputStream();){
                if (in == null) {
                    throw new FileNotFoundException(attFile.getPath());
                }
                Files.copy(in, tempFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
            return tempFilePath.toFile();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public class Answer {
        private PersistenceEntry file;
        private long attachmentLastModified;
        private boolean newAttachmentCreated;

        private Answer(PersistenceEntry file, long attachmentLastModified, boolean newAttachmentCreated) {
            this.file = file;
            this.attachmentLastModified = attachmentLastModified;
            this.newAttachmentCreated = newAttachmentCreated;
        }

        public PersistenceEntry getFile() {
            return this.file;
        }

        public long getAttachmentLastModified() {
            return this.attachmentLastModified;
        }

        public boolean isNewAttachmentCreated() {
            return this.newAttachmentCreated;
        }
    }
}

