/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.core.utils.SubListTaskExecutor;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentStatementProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ChecksumUtils;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class AttachmentDbDAO
implements AttachmentDAO {
    private AttachmentStatementProvider connectionProvider;

    public AttachmentDbDAO(AttachmentStatementProvider provider) {
        this.connectionProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAttachment(AttachmentRow row) throws SQLException {
        String sql = "INSERT INTO tblAttachments (type, ownerId, secondId, thirdId, fileName, attachmentFileId, isEmbedded, lastModified) select ?, ?, ?, ?, ?, attachmentFileId, ?, ? from tblAttachmentFiles where checksum=? and filelength=?";
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, row.getType().getId());
            pstm.setInt(2, row.getOwnerId());
            pstm.setInt(3, row.getStepId());
            pstm.setInt(4, row.getAdditionalId());
            pstm.setBytes(5, this.strToBytes(row.getFileName()));
            pstm.setBoolean(6, row.isEmbedded());
            pstm.setLong(7, row.getLastModified());
            pstm.setBytes(8, ChecksumUtils.hexStringToBytes(row.getChecksum()));
            pstm.setLong(9, row.getFileLength());
            pstm.executeUpdate();
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttachment(AttachmentKey key) throws SQLException {
        String sql = "DELETE FROM tblAttachments WHERE type=? AND ownerId=? AND secondId=? AND thirdId=? AND fileName=?";
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, key.getType().getId());
            pstm.setInt(2, key.getOwnerId());
            pstm.setInt(3, key.getStepId());
            pstm.setInt(4, key.getAdditionalId());
            pstm.setBytes(5, this.strToBytes(key.getFileName()));
            pstm.executeUpdate();
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachmentRow getAttachment(AttachmentKey key) throws SQLException {
        String sql = "SELECT checksum, filelength, isEmbedded, lastModified FROM tblAttachments INNER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId WHERE ownerId = ? AND secondId = ? AND thirdId = ? AND type = ? AND fileName = ?";
        AttachmentRow attachmentRow = null;
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, key.getOwnerId());
            pstm.setInt(2, key.getStepId());
            pstm.setInt(3, key.getAdditionalId());
            pstm.setInt(4, key.getType().getId());
            pstm.setBytes(5, this.strToBytes(key.getFileName()));
            try (ResultSet rs = pstm.executeQuery();){
                if (rs.next()) {
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(1));
                    long fileLength = rs.getLong(2);
                    boolean isEmbedded = rs.getBoolean(3);
                    long lastModified = rs.getLong(4);
                    attachmentRow = new AttachmentRow(key, checksum, fileLength, isEmbedded, lastModified);
                }
            }
            AttachmentRow attachmentRow2 = attachmentRow;
            return attachmentRow2;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentRow> getAttachments(AttachmentOwnerType type, int id) throws SQLException {
        String sql = "SELECT secondId, thirdId, fileName, checksum, filelength, isEmbedded, lastModified FROM tblAttachments INNER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId WHERE ownerId = ? AND type = ?";
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, id);
            pstm.setInt(2, type.getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    Integer stepId = rs.getInt(1);
                    Integer additionalId = rs.getInt(2);
                    String fileName = AttachmentDbDAO.bytesToStr(rs.getBytes(3));
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(4));
                    long fileLength = rs.getLong(5);
                    boolean isEmbedded = rs.getBoolean(6);
                    long lastModified = rs.getLong(7);
                    AttachmentKey key = new AttachmentKey(type, id, stepId, additionalId, fileName);
                    AttachmentRow row = new AttachmentRow(key, checksum, fileLength, isEmbedded, lastModified);
                    attachmentRows.add(row);
                }
            }
            ArrayList<AttachmentRow> arrayList = attachmentRows;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentRow> getAttachments(AttachmentOwnerType type, int id, int stepId) throws SQLException {
        String sql = "SELECT thirdId, fileName, checksum, filelength, isEmbedded, lastModified FROM tblAttachments INNER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId WHERE ownerId = ? AND secondId = ? AND type = ?";
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, id);
            pstm.setInt(2, stepId);
            pstm.setInt(3, type.getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    Integer additionalId = rs.getInt(1);
                    String fileName = AttachmentDbDAO.bytesToStr(rs.getBytes(2));
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(3));
                    long fileLength = rs.getLong(4);
                    boolean isEmbedded = rs.getBoolean(5);
                    long lastModified = rs.getLong(6);
                    AttachmentKey key = new AttachmentKey(type, id, stepId, additionalId, fileName);
                    AttachmentRow row = new AttachmentRow(key, checksum, fileLength, isEmbedded, lastModified);
                    attachmentRows.add(row);
                }
            }
            ArrayList<AttachmentRow> arrayList = attachmentRows;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttachment(AttachmentKey key, String checksum, long fileLength, long lastModified) throws SQLException {
        String sql = "UPDATE tblAttachments SET attachmentFileId = (select attachmentFileId from tblAttachmentFiles where filelength=? and checksum=? ), lastModified = ? WHERE ownerId = ? AND secondId = ? AND thirdId = ? AND type = ? AND fileName = ?";
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setLong(1, fileLength);
            pstm.setBytes(2, ChecksumUtils.hexStringToBytes(checksum));
            pstm.setLong(3, lastModified);
            pstm.setInt(4, key.getOwnerId());
            pstm.setInt(5, key.getStepId());
            pstm.setInt(6, key.getAdditionalId());
            pstm.setInt(7, key.getType().getId());
            pstm.setBytes(8, this.strToBytes(key.getFileName()));
            pstm.executeUpdate();
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAttachmentFile(AttachmentFileRow row) throws SQLException {
        String sql = "INSERT INTO tblAttachmentFiles (checksum, parentDirectoryPath, filelength) VALUES (?, ?, ?)";
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setBytes(1, ChecksumUtils.hexStringToBytes(row.getChecksum()));
            pstm.setString(2, row.getDirectoryPath());
            pstm.setLong(3, row.getFileLength());
            pstm.executeUpdate();
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttachmentFile(String checksum, long fileLength) throws SQLException {
        String sql = "DELETE FROM tblAttachmentFiles WHERE checksum = ? AND filelength = ?";
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setBytes(1, ChecksumUtils.hexStringToBytes(checksum));
            pstm.setLong(2, fileLength);
            pstm.executeUpdate();
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachmentFileRow getAttachmentFile(String checksum, long fileLength) throws SQLException {
        String sql = "SELECT parentDirectoryPath FROM tblAttachmentFiles WHERE checksum = ? AND filelength = ?";
        AttachmentFileRow attachmentFileRow = null;
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setBytes(1, ChecksumUtils.hexStringToBytes(checksum));
            pstm.setLong(2, fileLength);
            try (ResultSet rs = pstm.executeQuery();){
                if (rs.next()) {
                    String path = rs.getString(1);
                    attachmentFileRow = new AttachmentFileRow(checksum, path, fileLength);
                }
            }
            AttachmentFileRow attachmentFileRow2 = attachmentFileRow;
            return attachmentFileRow2;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfAttachmentsForFile(String checksum, long fileLength) throws SQLException {
        String sql = "SELECT COUNT(*) FROM tblAttachments WHERE attachmentFileId = (SELECT attachmentFileId FROM tblAttachmentFiles WHERE checksum = ? AND filelength = ?)";
        int numberOfAttachmentsForFile = 0;
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setBytes(1, ChecksumUtils.hexStringToBytes(checksum));
            pstm.setLong(2, fileLength);
            try (ResultSet rs = pstm.executeQuery();){
                if (rs.next()) {
                    numberOfAttachmentsForFile = rs.getInt(1);
                }
            }
            int n = numberOfAttachmentsForFile;
            return n;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    @Override
    public List<AttachmentRow> getAttachmentsForFile(String checksum, long fileLength) throws SQLException {
        int entryLimit = Integer.MAX_VALUE;
        return this.getAttachmentsForFile(checksum, fileLength, entryLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentRow> getAttachmentsForFile(String checksum, long fileLength, int entryLimit) throws SQLException {
        String sql = "SELECT type, ownerId, secondId, thirdId, fileName, isEmbedded, lastModified FROM tblAttachments WHERE attachmentFileId = (SELECT attachmentFileId FROM tblAttachmentFiles WHERE checksum = ? AND filelength = ?)";
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setBytes(1, ChecksumUtils.hexStringToBytes(checksum));
            pstm.setLong(2, fileLength);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    if (attachmentRows.size() >= entryLimit) {
                        break;
                    }
                    AttachmentOwnerType type = AttachmentOwnerType.getTypeForId(rs.getInt(1));
                    Integer ownerId = rs.getInt(2);
                    Integer stepId = rs.getInt(3);
                    Integer additionalId = rs.getInt(4);
                    String fileName = AttachmentDbDAO.bytesToStr(rs.getBytes(5));
                    boolean isEmbedded = rs.getBoolean(6);
                    long lastModified = rs.getLong(7);
                    AttachmentKey key = new AttachmentKey(type, ownerId, stepId, additionalId, fileName);
                    AttachmentRow row = new AttachmentRow(key, checksum, fileLength, isEmbedded, lastModified);
                    attachmentRows.add(row);
                }
            }
            ArrayList<AttachmentRow> arrayList = attachmentRows;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachmentFileRow getAttachmentFile(AttachmentKey key) throws SQLException {
        String selectPart = "SELECT tblAttachmentFiles.checksum, tblAttachmentFiles.parentDirectoryPath, tblAttachmentFiles.filelength FROM tblAttachmentFiles ";
        String joinPart = "INNER JOIN tblAttachments ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId ";
        String wherePart = "WHERE tblAttachments.ownerId = ? AND tblAttachments.secondId = ? AND tblAttachments.thirdId = ? AND tblAttachments.type = ? AND tblAttachments.fileName = ?";
        String sql = selectPart + joinPart + wherePart;
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, key.getOwnerId());
            pstm.setInt(2, key.getStepId());
            pstm.setInt(3, key.getAdditionalId());
            pstm.setInt(4, key.getType().getId());
            pstm.setBytes(5, this.strToBytes(key.getFileName()));
            try (ResultSet rs = pstm.executeQuery();){
                if (rs.next()) {
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(1));
                    String path = rs.getString(2);
                    long fileLength = rs.getLong(3);
                    AttachmentFileRow attachmentFileRow = new AttachmentFileRow(checksum, path, fileLength);
                    return attachmentFileRow;
                }
            }
            AttachmentFileRow attachmentFileRow = null;
            return attachmentFileRow;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFileNamesFromAttachments(AttachmentOwnerType type, int id) throws SQLException {
        String sql = "SELECT fileName FROM tblAttachments WHERE ownerId = ? AND type = ?";
        ArrayList<String> fileNames = new ArrayList<String>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, id);
            pstm.setInt(2, type.getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    fileNames.add(AttachmentDbDAO.bytesToStr(rs.getBytes(1)));
                }
            }
            ArrayList<String> arrayList = fileNames;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFileNamesFromAttachments(AttachmentOwnerType type, int id, int stepId) throws SQLException {
        String sql = "SELECT fileName FROM tblAttachments WHERE ownerId = ? AND secondId = ? AND type = ?";
        ArrayList<String> fileNames = new ArrayList<String>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, id);
            pstm.setInt(2, stepId);
            pstm.setInt(3, type.getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    fileNames.add(AttachmentDbDAO.bytesToStr(rs.getBytes(1)));
                }
            }
            ArrayList<String> arrayList = fileNames;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    @Override
    public Map<AttachmentRow, AttachmentFileRow> getFullAttachmentDataForOwner(final AttachmentOwnerType type, List<Integer> ticketIds, final boolean includeEmbedded) throws SQLException {
        final HashMap<AttachmentRow, AttachmentFileRow> resultMap = new HashMap<AttachmentRow, AttachmentFileRow>();
        try {
            new SubListTaskExecutor().executeForEachSubList(ticketIds, 900, (SubListTaskExecutor.SubListExecutionTask)new SubListTaskExecutor.SubListExecutionTask<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(List<Integer> subList) throws Exception {
                    Object ids = subList.toString();
                    ids = "(" + ((String)ids).substring(1, ((String)ids).length() - 1) + ")";
                    String selectPart = "SELECT type, ownerId, secondId, thirdId, fileName, checksum, filelength, isEmbedded, parentDirectoryPath, lastModified FROM tblAttachments ";
                    String joinPart = "INNER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId ";
                    String wherePart = "WHERE tblAttachments.ownerId IN " + (String)ids;
                    wherePart = wherePart + " AND type = ?";
                    if (!includeEmbedded) {
                        wherePart = wherePart + " AND isEmbedded = 0";
                    }
                    String sql = selectPart + joinPart + wherePart;
                    PreparedStatement pstm = null;
                    try {
                        pstm = AttachmentDbDAO.this.connectionProvider.getPreparedStatement(sql);
                        pstm.setInt(1, type.getId());
                        try (ResultSet rs = pstm.executeQuery();){
                            while (rs.next()) {
                                Integer id = rs.getInt(2);
                                Integer stepId = rs.getInt(3);
                                Integer additionalId = rs.getInt(4);
                                String fileName = AttachmentDbDAO.bytesToStr(rs.getBytes(5));
                                String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(6));
                                long fileLength = rs.getLong(7);
                                boolean isEmbedded = rs.getBoolean(8);
                                String path = rs.getString(9);
                                long lastModified = rs.getLong(10);
                                AttachmentKey key = new AttachmentKey(type, id, stepId, additionalId, fileName);
                                AttachmentRow row = new AttachmentRow(key, checksum, fileLength, isEmbedded, lastModified);
                                AttachmentFileRow fileRow = new AttachmentFileRow(checksum, path, fileLength);
                                resultMap.put(row, fileRow);
                            }
                        }
                    }
                    finally {
                        AttachmentDbDAO.this.connectionProvider.closePreparedStatement(pstm);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw (SQLException)ex;
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countAttachments(AttachmentOwnerType type, int id, boolean includeEmbedded) throws SQLException {
        Object sql = "SELECT COUNT(*) FROM tblAttachments WHERE type = ? AND ownerId = ?";
        if (!includeEmbedded) {
            sql = (String)sql + " AND isEmbedded = 0";
        }
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement((String)sql);
            pstm.setInt(1, type.getId());
            pstm.setLong(2, id);
            try (ResultSet rs = pstm.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    @Override
    public int countAttachments(final AttachmentOwnerType type, List<Integer> bundledTicketIds, final boolean includeEmbedded) throws SQLException {
        final AtomicInteger count = new AtomicInteger(0);
        try {
            new SubListTaskExecutor().executeForEachSubList(bundledTicketIds, 900, (SubListTaskExecutor.SubListExecutionTask)new SubListTaskExecutor.SubListExecutionTask<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(List<Integer> subList) throws Exception {
                    Object sql = "SELECT COUNT(*) FROM tblAttachments WHERE type = ? AND ownerId IN ( ";
                    String listString = subList.toString();
                    listString = listString.substring(1, listString.length() - 1);
                    sql = (String)sql + listString + ") ";
                    if (!includeEmbedded) {
                        sql = (String)sql + " AND isEmbedded = 0";
                    }
                    PreparedStatement pstm = null;
                    try {
                        pstm = AttachmentDbDAO.this.connectionProvider.getPreparedStatement((String)sql);
                        pstm.setInt(1, type.getId());
                        try (ResultSet rs = pstm.executeQuery();){
                            if (rs.next()) {
                                count.addAndGet(rs.getInt(1));
                            }
                        }
                    }
                    finally {
                        AttachmentDbDAO.this.connectionProvider.closePreparedStatement(pstm);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw (SQLException)ex;
        }
        return count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentKey> getAttachmentKeys(AttachmentOwnerType type) throws SQLException {
        String sql = "SELECT ownerId, secondId, thirdId, fileName FROM tblAttachments WHERE type = ?";
        ArrayList<AttachmentKey> attachmentKeys = new ArrayList<AttachmentKey>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setInt(1, type.getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    Integer ownerId = rs.getInt(1);
                    Integer stepId = rs.getInt(2);
                    Integer additionalId = rs.getInt(3);
                    String fileName = AttachmentDbDAO.bytesToStr(rs.getBytes(4));
                    AttachmentKey key = new AttachmentKey(type, ownerId, stepId, additionalId, fileName);
                    attachmentKeys.add(key);
                }
            }
            ArrayList<AttachmentKey> arrayList = attachmentKeys;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentFileRow> getAllAttachmentFiles() throws SQLException {
        String sql = "SELECT checksum, filelength, parentDirectoryPath FROM tblAttachmentFiles";
        ArrayList<AttachmentFileRow> attachmentFileRows = new ArrayList<AttachmentFileRow>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(1));
                    long fileLength = rs.getLong(2);
                    String path = rs.getString(3);
                    attachmentFileRows.add(new AttachmentFileRow(checksum, path, fileLength));
                }
            }
            ArrayList<AttachmentFileRow> arrayList = attachmentFileRows;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<AttachmentFileRow, Integer> getAllAttachmentFilesWithReferenceCount() throws SQLException {
        String sql = "SELECT checksum, filelength, parentDirectoryPath, (SELECT COUNT(*) FROM tblAttachments A WHERE A.attachmentFileId = B.attachmentFileId) FROM tblAttachmentFiles B";
        HashMap<AttachmentFileRow, Integer> attFilesToReferenceCount = new HashMap<AttachmentFileRow, Integer>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(1));
                    long fileLength = rs.getLong(2);
                    String path = rs.getString(3);
                    int refCount = rs.getInt(4);
                    attFilesToReferenceCount.put(new AttachmentFileRow(checksum, path, fileLength), refCount);
                }
            }
            HashMap<AttachmentFileRow, Integer> hashMap = attFilesToReferenceCount;
            return hashMap;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    @Override
    public int getNumberOfAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        String sql = "SELECT COUNT(*) FROM tblAttachmentFiles WHERE attachmentFileId NOT IN ( SELECT DISTINCT attachmentFileId FROM tblAttachments )";
        PreparedStatement pstm = null;
        try {
            int n;
            block13: {
                ResultSet rs;
                block11: {
                    int n2;
                    block12: {
                        pstm = this.connectionProvider.getPreparedStatement(sql);
                        rs = pstm.executeQuery();
                        try {
                            if (!rs.next()) break block11;
                            n2 = rs.getInt(1);
                            if (rs == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return n2;
                }
                n = 0;
                if (rs == null) break block13;
                rs.close();
            }
            return n;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentFileRow> getAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        String sql = "SELECT checksum, filelength, parentDirectoryPath FROM tblAttachmentFiles WHERE attachmentFileId NOT IN ( SELECT DISTINCT attachmentFileId FROM tblAttachments )";
        ArrayList<AttachmentFileRow> attachmentFileRows = new ArrayList<AttachmentFileRow>();
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(1));
                    long fileLength = rs.getLong(2);
                    String path = rs.getString(3);
                    attachmentFileRows.add(new AttachmentFileRow(checksum, path, fileLength));
                }
            }
            ArrayList<AttachmentFileRow> arrayList = attachmentFileRows;
            return arrayList;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    @Override
    public long getTotalLengthOfAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        String sql = "SELECT SUM(filelength) FROM tblAttachmentFiles WHERE attachmentFileId NOT IN ( SELECT DISTINCT attachmentFileId FROM tblAttachments )";
        PreparedStatement pstm = null;
        try {
            long l;
            block13: {
                ResultSet rs;
                block11: {
                    long l2;
                    block12: {
                        pstm = this.connectionProvider.getPreparedStatement(sql);
                        rs = pstm.executeQuery();
                        try {
                            if (!rs.next()) break block11;
                            l2 = rs.getLong(1);
                            if (rs == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = 0L;
                if (rs == null) break block13;
                rs.close();
            }
            return l;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        String sql = "DELETE FROM tblAttachmentFiles WHERE attachmentFileId NOT IN ( SELECT DISTINCT attachmentFileId FROM tblAttachments )";
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            int n = pstm.executeUpdate();
            return n;
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }

    private byte[] strToBytes(String str) throws SQLException {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e);
        }
    }

    public static String bytesToStr(byte[] bytes) throws SQLException {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttachmentFilePath(String checksum, long fileLength, String parentDirPath) throws SQLException {
        String sql = "update tblAttachmentFiles SET parentDirectoryPath = ? where  checksum = ? and filelength = ?";
        PreparedStatement pstm = null;
        try {
            pstm = this.connectionProvider.getPreparedStatement(sql);
            pstm.setString(1, parentDirPath);
            pstm.setBytes(2, ChecksumUtils.hexStringToBytes(checksum));
            pstm.setLong(3, fileLength);
            int rowAffected = pstm.executeUpdate();
            if (rowAffected != 1) {
                AttachmentsServerPlugin.LOGGER.warn((Object)String.format("Update of %s for checksum %s did not update any row", parentDirPath, checksum));
            }
        }
        finally {
            this.connectionProvider.closePreparedStatement(pstm);
        }
    }
}

