/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.BooleanMatcher;
import com.inet.helpdesk.plugins.attachments.shared.FilterableAttachmentDescription;
import java.util.ArrayList;
import java.util.List;

@JsonData
public class FilterableAttachments {
    private List<FilterableAttachmentDescription> filterableAttachmentDescriptions;

    private FilterableAttachments() {
    }

    public FilterableAttachments(List<FilterableAttachmentDescription> filterableAttachmentDescriptions) {
        if (filterableAttachmentDescriptions == null) {
            throw new IllegalArgumentException("list of filterable attachment descriptions must not be null");
        }
        this.filterableAttachmentDescriptions = filterableAttachmentDescriptions;
    }

    public List<AttachmentDescription> getMatched(BooleanMatcher uniquenessMatcher, BooleanMatcher embeddednessMatcher) {
        ArrayList<AttachmentDescription> requestedAttachments = new ArrayList<AttachmentDescription>();
        for (FilterableAttachmentDescription attInfo : this.filterableAttachmentDescriptions) {
            boolean isMatchedByUniqueness = uniquenessMatcher.matches(attInfo.isUnique());
            boolean isMatchedByEmbeddedness = embeddednessMatcher.matches(attInfo.isEmbedded());
            if (!isMatchedByUniqueness || !isMatchedByEmbeddedness) continue;
            requestedAttachments.add(attInfo.getDescription());
        }
        return requestedAttachments;
    }

    public int getNumberOfEmbeddedOrNonUniqueAttachments() {
        int counter = 0;
        for (FilterableAttachmentDescription attInfo : this.filterableAttachmentDescriptions) {
            boolean isNonUnique = BooleanMatcher.ONLY_FALSE.matches(attInfo.isUnique());
            boolean isEmbedded = BooleanMatcher.ONLY_TRUE.matches(attInfo.isEmbedded());
            if (!isNonUnique && !isEmbedded) continue;
            ++counter;
        }
        return counter;
    }

    public List<AttachmentDescription> getAll() {
        ArrayList<AttachmentDescription> attachments = new ArrayList<AttachmentDescription>();
        for (FilterableAttachmentDescription attInfo : this.filterableAttachmentDescriptions) {
            attachments.add(attInfo.getDescription());
        }
        return attachments;
    }

    public int size() {
        return this.filterableAttachmentDescriptions.size();
    }
}

