/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.mail;

import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.lib.util.EncodingFunctions;
import com.inet.mail.api.AttachedFile;
import java.util.List;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageReferenceReplacer {
    private static final Pattern IMG_PATTERN = Pattern.compile("(<\\s*?img[^>]*?\\ssrc\\s*?=)((\\s*?\"[^\"]*?\")|((?!/>)[^\\s>])+)([^>]*?>)", 2);
    private static final Pattern A_HREF_PATTERN = Pattern.compile("(<\\s*?a[^>]*?\\shref\\s*?=)((\\s*?\"[^\"]*?\")|((?!/>)[^\\s>])+)([^>]*?>)", 2);
    private static final Pattern[] PATTERNS = new Pattern[]{IMG_PATTERN, A_HREF_PATTERN};
    private static final String CID = "cid:";

    public static String replaceWithLargeContentFilename(List<AttachedFile> attachments, final List<LargeContent> lcs, String text, String httpHostTag) {
        if (attachments == null) {
            throw new IllegalArgumentException("AttFiles cannot be null!");
        }
        if (lcs == null) {
            throw new IllegalArgumentException("attDescriptions cannot be null!");
        }
        if (attachments.size() != lcs.size()) {
            throw new IllegalArgumentException(String.format("Length of attDescriptions (%d) and attFiles (%d) must be equal.", attachments.size(), lcs.size()));
        }
        if (text.isEmpty()) {
            return text;
        }
        if (attachments.isEmpty()) {
            return text;
        }
        ReplacementStringProvider replacementStringProvider = new ReplacementStringProvider(){

            @Override
            public String getReplacement(AttachedFile file, int indexInAttDescriptions) {
                LargeContent description = (LargeContent)lcs.get(indexInAttDescriptions);
                if (description != null) {
                    return description.getName();
                }
                return null;
            }
        };
        return ImageReferenceReplacer.replaceImageSources(attachments, text, httpHostTag, replacementStringProvider);
    }

    public static String replaceWithRestful(Vector<AttachedFile> attFiles, final AttachmentDescription[] attDescriptions, String text, String httpHostTag) {
        if (attFiles == null) {
            throw new IllegalArgumentException("AttFiles cannot be null!");
        }
        if (attDescriptions == null) {
            throw new IllegalArgumentException("attDescriptions cannot be null!");
        }
        if (attFiles.size() != attDescriptions.length) {
            throw new IllegalArgumentException(String.format("Length of attDescriptions (%d) and attFiles (%d) must be equal.", attDescriptions.length, attFiles.size()));
        }
        if (text.isEmpty()) {
            return text;
        }
        if (attFiles.isEmpty()) {
            return text;
        }
        ReplacementStringProvider replacementStringProvider = new ReplacementStringProvider(){

            @Override
            public String getReplacement(AttachedFile file, int indexInAttDescriptions) {
                AttachmentDescription description = attDescriptions[indexInAttDescriptions];
                if (description != null) {
                    return description.getRESTfulFilePath();
                }
                return null;
            }
        };
        return ImageReferenceReplacer.replaceImageSources(attFiles, text, httpHostTag, replacementStringProvider);
    }

    public static String replaceImageSources(Vector<AttachedFile> attFiles, String text, String httpHostTag) {
        ReplacementStringProvider replacementStringProvider = new ReplacementStringProvider(){

            @Override
            public String getReplacement(AttachedFile file, int indexInAttDescriptions) {
                String fileName = EncodingFunctions.encodeUrlPath((String)file.getFileName());
                return fileName;
            }
        };
        return ImageReferenceReplacer.replaceImageSources(attFiles, text, httpHostTag, replacementStringProvider);
    }

    private static String replaceImageSources(List<AttachedFile> attFiles, String text, String httpHostTag, ReplacementStringProvider replacementStringProvider) {
        if (attFiles == null || attFiles.isEmpty()) {
            return text;
        }
        return ImageReferenceReplacer.genericReplaceImageSources(text, src -> {
            String originalFileName = src;
            if (originalFileName.toLowerCase().startsWith(CID)) {
                originalFileName = originalFileName.substring(CID.length());
            }
            if (originalFileName.trim().length() == 0) {
                return src;
            }
            String replacementText = ImageReferenceReplacer.getReplacement(attFiles, httpHostTag, originalFileName, replacementStringProvider);
            if (replacementText == null) {
                return src;
            }
            return replacementText;
        });
    }

    private static String getReplacement(List<AttachedFile> attFiles, String httpHostTag, String originalFileName, ReplacementStringProvider replacementStringProvider) {
        BiFunction<AttachedFile, Integer, String> getReplacement = (f, i) -> {
            Object fname = replacementStringProvider.getReplacement((AttachedFile)f, (int)i);
            if (httpHostTag != null) {
                fname = httpHostTag + "/" + (String)fname;
            }
            return fname;
        };
        for (int index = 0; index < attFiles.size(); ++index) {
            String[] toTest;
            AttachedFile file = attFiles.get(index);
            if (originalFileName.equalsIgnoreCase(file.getOriginalFileName())) {
                return getReplacement.apply(file, index);
            }
            if (file.getLocation() != null) {
                for (String element : toTest = file.getLocation()) {
                    if (!originalFileName.equalsIgnoreCase(element)) continue;
                    return getReplacement.apply(file, index);
                }
            }
            if (file.getContentID() == null) continue;
            for (String element : toTest = file.getContentID()) {
                if (element.indexOf(originalFileName) <= -1) continue;
                return getReplacement.apply(file, index);
            }
        }
        return null;
    }

    public static String genericReplaceImageSources(String text, Function<String, String> replacementProvider) {
        for (Pattern p : PATTERNS) {
            Matcher m = p.matcher(text);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String originalFileName = m.group(2);
                if (originalFileName.startsWith("\"") && originalFileName.endsWith("\"")) {
                    originalFileName = originalFileName.substring(1, originalFileName.length() - 1);
                }
                Object replacementText = replacementProvider.apply(originalFileName);
                replacementText = m.group(1) + "\"" + (String)replacementText + "\"" + m.group(5);
                replacementText = ((String)replacementText).replace("\\", "\\\\");
                replacementText = ((String)replacementText).replace("$", "\\$");
                m.appendReplacement(sb, (String)replacementText);
            }
            m.appendTail(sb);
            text = sb.toString();
        }
        return text;
    }

    public static String genericReplaceImageSourcesInImagesOnly(String text, Function<String, String> replacementProvider) {
        Pattern p = IMG_PATTERN;
        Matcher m = p.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String originalFileName = m.group(2);
            if (originalFileName.startsWith("\"") && originalFileName.endsWith("\"")) {
                originalFileName = originalFileName.substring(1, originalFileName.length() - 1);
            }
            Object replacementText = replacementProvider.apply(originalFileName);
            replacementText = m.group(1) + "\"" + (String)replacementText + "\"" + m.group(5);
            replacementText = ((String)replacementText).replace("\\", "\\\\");
            replacementText = ((String)replacementText).replace("$", "\\$");
            m.appendReplacement(sb, (String)replacementText);
        }
        m.appendTail(sb);
        text = sb.toString();
        return text;
    }

    private static interface ReplacementStringProvider {
        public String getReplacement(AttachedFile var1, int var2);
    }
}

